/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GiEmpty {
    
    private SgfId sgfType_;
    private String value_;
    /**
     * 
     */
    public GiEmpty() {
        super();
        sgfType_ = SgfId.BLACK;
        value_ = Strings.EMPTY;
    }

    public void setType(String type) {
        ArgumentChecker.throwIfNull(type);
        sgfType_ = SgfId.find(type);
    }

    public void setValue(String value) {
        ArgumentChecker.throwIfNull(value);
        value_ = value;
    }

    public SgfId getSgfType() {
        return sgfType_;
    }

    public String getValue() {
        return value_;
    }
}
