/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.regex.Pattern;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link #replace(String)}ɁA
 * {@link #setRegx(String)}Ŏw肳鐳K\Ƀ}b`ꍇɁA
 * {@link #setValue(String)}Ŏw肵lԂjbgłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GiEnum {
    
    private SgfId sgfType_;
    private Pattern pattern_;
    private String value_;
    
    /**
     * 
     */
    public GiEnum() {
        super();
        sgfType_ = SgfId.BLACK;
        pattern_ = Pattern.compile("^$"); //$NON-NLS-1$
        value_ = Strings.EMPTY;
    }

    public void setType(String type) {
        ArgumentChecker.throwIfNull(type);
        sgfType_ = SgfId.find(type);
    }

    public void setRegx(String regx) {
        ArgumentChecker.throwIfNull(regx);
        pattern_ = Pattern.compile(regx);
    }
    
    public void setValue(String value) {
        ArgumentChecker.throwIfNull(value);
        value_ = value;
    }
    
    public SgfId getSgfType() {
        return sgfType_;
    }

    public Pattern getPattern() {
        return pattern_;
    }
    
    public String getValue() {
        return value_;
    }

    /**
     * @param text
     * @return
     */
    public String replace(String text) {
        return pattern_.matcher(text).replaceFirst(value_);
    }
}
