/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * \ۂɈӖ̂vpeB܂Ƃ߂NXłB
 * 
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GiItem implements WidgetContainer, NodeMonitor {
    
    /** ̃NX̃K[łB*/
    static private final  Log logger_s_ = LogFactory.getLog(GiItem.class);
    
    /**
     * text%n܂ĂƂpropertiesKeyƂ݂ȂăeLXgԂ܂B
     * ȊÔƂ͂̂܂ܕԂ܂B
     * KeyȂƂ͌xo{@link Strings#EMPTY}Ԃ܂B
     */
    static public String convert(String text, Properties properties) {
        if (text.startsWith("%")) { //$NON-NLS-1$
            String key = text.substring(1);
            String ret = properties.getProperty(key);
            if (ret == null) {
    			logger_s_.warn("Cannot find the key = " + key); //$NON-NLS-1$
                return Strings.EMPTY;
            }
            return ret;
        }
        return text;
    }
    
    
	static private final Messages messages_s_ = Messages.createByPackage(GiItem.class);

    private String labelText_;
    private String expression_;
    
    /**
     * ^[{@link SgfId}, String] 
     * Property݂ȂƂ̕\ڂݒ肵܂B
     */
    private final Map<SgfId, String> emptyMap_;
    
    /**
     * ^[{@link SgfId}, List[{@link GiEnum}]]łB
     */
    private final Map<SgfId, List<GiEnum>> enumMap_;
    
    private Composite composite_;
    
    /** ACe̍[̃xłB̍ڂ̂ݑŜŉEɂȂ܂B */
    private Label label_;
    
    /** ۂ̒li[LabelText܂B */
    private GiFormula[] giFormulae_;
    
    /**
     * 
     */
    public GiItem() {
        super();
        labelText_ = Strings.EMPTY;
        expression_ = Strings.EMPTY;
        emptyMap_ = new TreeMap<SgfId, String>();
        enumMap_ = new TreeMap<SgfId, List<GiEnum>>();
        
        giFormulae_ = new GiFormula[0];
        
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.swt.ControlCreatable#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        setup();
        composite_ = new Composite(parent, SWT.NONE);
        
        GridLayout gridLayout = new GridLayout(giFormulae_.length + 1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 4;
        composite_.setLayout(gridLayout);
        GridData gridData = new GridData(GridData.END, GridData.BEGINNING, false, false);
        label_ = new Label(composite_, SWT.RIGHT);
        label_.setText(labelText_);
        label_.setLayoutData(gridData);
        for (GiFormula giFormula : giFormulae_) {
            Control control = giFormula.createContents(composite_);
        	gridData = new GridData(GridData.BEGINNING, GridData.BEGINNING, true, true);
            control.setLayoutData(gridData);
            
            // seLXg1łꍇ͖ɏcς݂ɂĂB
            // TEXTƂȊÕvpeBPsɍ݂ĂƂȕ\ɂȂ̂ŒӁI
            SgfId sgfId = giFormula.getSgfId();
            if ((sgfId != null) && ValueType.TEXT.equals(sgfId.valueType())) {
            	gridLayout.numColumns = 1; 
            	((GridData)label_.getLayoutData()).horizontalAlignment = GridData.BEGINNING;
            }
        }
        return composite_;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.swt.ControlCreatable#dispose()
     */
    public void dispose() {
        if (composite_ == null) {
            return;
        }
        composite_.dispose();
        composite_ = null;
    }

    /**
     * labelɍ킹ĕ\鍀ڂ肵܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException ̉ꂩłnull̏ꍇB
     */
    public void setLabel(String label) {
        ArgumentChecker.throwIfNull(label);
        labelText_ = label;
    }
    
    /**
     * expressionɍ킹ĕ\鍀ڂ肵܂B<br>
     * expression ̓vpeBIDƃt[eLXg̍\ŁA
     * ႦΎ̂悤Ȍ`ɂȂ܂F<code>WN [WR]</code>B
     * ̏ꍇAŏɔ̖O\AŃXy[XƃJM'['
     * \Ǎɔ̒iʂ\AŌɃJM']'\܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException ̉ꂩłnull̏ꍇB
     */
    public void setExpression(String expression) {
        ArgumentChecker.throwIfNull(expression);
        expression_ = expression;
    }
    
    public void addEmpty(GiEmpty empty) {
        ArgumentChecker.throwIfNull(empty);
        emptyMap_.put(empty.getSgfType(), empty.getValue());
    }
    
    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull(giEnum);
        List<GiEnum> list = enumMap_.get(giEnum.getSgfType());
        if (list == null) {
            list = new ArrayList<GiEnum>();
            enumMap_.put(giEnum.getSgfType(), list);
        }
        list.add(giEnum);
    }

    
    /**
     * {@link #expression_}{@link #giFormulae_}\܂B
     * 헪<br>
     * EꕶǂݍŃAt@xbg̑啶ƍ<br>
     * @EŃL[ɕꍇ͂gݍ킹ďƍB
     * EPropertyɑ݂Ȃꍇ̓L[ɓ(L[̏͂Pj
     * EAt@xbg啶ȊO̕L[NA[ĕ\ɒǉ
     */
    public void setup() {
        List<GiFormula> giFormulaList = new ArrayList<GiFormula>(); 
        StringBuilder text = new StringBuilder(expression_.length());
        char queue = CharacterIterator.DONE;
        CharacterIterator ip = new StringCharacterIterator(expression_);
        for (char c = ip.first(); c != CharacterIterator.DONE; c = ip.next()) {
            if (!Strings.isUppercaseRomanAlphabet(c)) {
                if (queue != CharacterIterator.DONE) {
                    text.append(queue);
                    queue = CharacterIterator.DONE;
                }
                text.append(c);
                continue;
            }
            StringBuilder id = new StringBuilder(2); //ID̃TCY͍XQ
            if (queue != CharacterIterator.DONE) {
                id.append(queue);
            }
            id.append(c);
            SgfId sgfType = (SgfId)UEnum.find(SgfId.class, id.toString());
            if ((sgfType == null) 
                    || !PropertyType.GAME_INFO.equals(sgfType.propertyType())) {
                if (queue != CharacterIterator.DONE) {
                    text.append(queue);
                }
                queue = c;
                continue;
            }
            if (text.length() != 0 ) {
                giFormulaList.add(new GiLabelFormula(text.toString()));
                text.delete(0, text.length());
            }
            GiTextFormula giTextFormula = new GiTextFormula(sgfType);
            String value = emptyMap_.get(sgfType);
            if (value != null) {
                giTextFormula.setEmpty(value);
            }
            List<GiEnum> giEnums = enumMap_.get(sgfType);
            if (giEnums != null) {
            	for (GiEnum giEnum : giEnums) {
                    String value2 = giEnum.getValue();
                    if (value2.startsWith("%")) {
                        String key = value2.substring(1);
                        value2 = messages_s_.get(key);
                        giEnum.setValue(value2);
                    }
                    giTextFormula.addEnum(giEnum);
                }
            }
            giFormulaList.add(giTextFormula);
            queue = CharacterIterator.DONE;
        }
        if (text.length() != 0 ) {
            giFormulaList.add(new GiLabelFormula(text.toString()));
        }
        
        for (int i = 0; i < giFormulae_.length; ++i) {
            giFormulae_[i].dispose();
        }
        giFormulae_ = giFormulaList.toArray(new GiFormula[giFormulaList.size()]);
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.NodeDisplay#update(org.unitarou.yukinoshita.model.NodeView)
     */
    public void currentChanged(NodeView nodeView) {
        ArgumentChecker.throwIfNull(nodeView);
        for (int i = 0; i < giFormulae_.length; ++i) {
            giFormulae_[i].currentChanged(nodeView);
        }
    }


    /**
     * @param properties
     */
    public void setLocalizedLabel(Properties properties) {
        ArgumentChecker.throwIfNull(properties);

        labelText_ = convert(labelText_, properties);
        
        for (int i = 0; i < giFormulae_.length; ++i) {
            giFormulae_[i].setLabel(properties);
        }
        for (SgfId key : emptyMap_.keySet()) {
            String value = emptyMap_.get(key);
            emptyMap_.put(key, convert(value, properties));
        }
    }

	/**
	 * @param width
	 */
	public void setWidth(int width) {
		Point lbPt = label_.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		if (((GridLayout)composite_.getLayout()).numColumns == 1) {
			lbPt.x = 0;
		}
		for (GiFormula giFormula : giFormulae_) {
			Control control = giFormula.getControl();
			GridData gridData = (GridData)control.getLayoutData();
			gridData.widthHint = width - lbPt.x - (gridData.horizontalSpan  + gridData.horizontalIndent) * 2;
		}
	}
}
