/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.Properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * {@link org.eclipse.swt.widgets.Label}ŕ\
 * {@link org.unitarou.yukinoshita.view.jface.gi.GiFormula}łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GiLabelFormula implements GiFormula {
    
    private Label label_;
    
    private String text_;

    /**
     * 
     */
    public GiLabelFormula(String text) {
        super();
        ArgumentChecker.throwIfNull(text);
        label_ = null;
        text_ = text;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.ControlCreatable#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull(parent);
        label_ = new Label(parent, SWT.LEFT);
        label_.setText(text_);
        return label_;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.ControlCreatable#dispose()
     */
    public void dispose() {
        if (label_ == null) {
            return;
        }
        label_.dispose();
        label_ = null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#update(org.unitarou.yukinoshita.model.NodeView)
     */
    public void currentChanged(NodeView nodeView) {
        // ܂
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#getSgfType()
     */
    public SgfId getSgfId() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#setLabel(java.util.Properties)
     */
    public void setLabel(Properties properties) {
        ArgumentChecker.throwIfNull(properties);
        text_ = GiItem.convert(text_, properties);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.gi.GiFormula#getControl()
	 */
	public Control getControl() {
		return label_;
	}
}
