/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.swt.Layouts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * {@link org.unitarou.yukinoshita.view.jface.gi.GameInfoPlainPanel}
 * Ps\CX^XłB<br>
 * ɂPȏ{@link org.unitarou.yukinoshita.view.jface.gi.GiItem}A
 * ̑ɉčω܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GiLine 
		implements WidgetContainer, NodeMonitor {
    
    private Composite composite_;

    /** ^{@link GiItem}*/
    private final List<GiItem> giItems_;
    /**
     * 
     */
    public GiLine() {
        super();
        giItems_ = new ArrayList<GiItem>();
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.swt.ControlCreatable#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull(parent);

        composite_ = new Composite(parent, SWT.NONE);
        composite_.setLayout(Layouts.createRow(SWT.HORIZONTAL, 0, 0));
        for (Iterator ip = giItems_.iterator(); ip.hasNext(); ) {
            GiItem giItem = (GiItem)ip.next();
            giItem.createContents(composite_);
        }
        
        return composite_;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.ControlCreatable#dispose()
     */
    public void dispose() {
        // TODO Auto-generated method stub
        
    }

    public void addItem(GiItem giItem) {
        giItems_.add(giItem);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.NodeDisplay#update(org.unitarou.yukinoshita.model.NodeView)
     */
    public void currentChanged(NodeView nodeView) {
        ArgumentChecker.throwIfNull(nodeView);

        for (Iterator ip = giItems_.iterator(); ip.hasNext(); ) {
            GiItem giItem = (GiItem)ip.next();
            giItem.currentChanged(nodeView);
        }
    }

    /**
     * @param properties
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public void setLabel(Properties properties) {
        ArgumentChecker.throwIfNull(properties);
        for (Iterator ip = giItems_.iterator(); ip.hasNext(); ) {
            GiItem giItem = (GiItem)ip.next();
            giItem.setLocalizedLabel(properties);
        }
    }

    /**
	 * @param width
	 */
	public void setWidth(int width) {
		if (giItems_.size() != 1) {
			return;
		}
		for (GiItem giItem : giItems_) {
			giItem.setWidth(width);
		}
	}

	/**
	 * @return
	 */
	public Control getControl() {
		return composite_;
	}
}
