/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * {@link org.eclipse.swt.widgets.Text}ŕ\
 * {@link org.unitarou.yukinoshita.view.jface.gi.GiFormula}łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GiTextFormula implements GiFormula {
    
    /**
     * {@link #setEmpty(String)w肵Ȃꍇ
     * Property݂Ȃꍇ̑pl(Xy[X)łB
     */
    static private final String EMPTY = " "; //$NON-NLS-1$

    private Label label_;
    private final SgfId sgfType_;
    private String empty_;
    private final List<GiEnum> giEnums_;
    
    /**
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public GiTextFormula(SgfId sgfType) {
        super();
        ArgumentChecker.throwIfNull(sgfType);
        label_ = null;
        sgfType_ = sgfType;    
        empty_ = EMPTY;
        giEnums_ = new ArrayList<GiEnum>();
    }
    
    public void setEmpty(String empty) {
        ArgumentChecker.throwIfNull(empty);
        empty_ = empty;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull(parent);
        int style = SWT.WRAP;
        label_ = new Label(parent, style);
        return label_;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#dispose()
     */
    public void dispose() {
        if (label_ == null) {
            return;
        }
        label_.dispose();
        label_ = null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#update(org.unitarou.yukinoshita.model.NodeView)
     */
    public void currentChanged(NodeView nodeView) {
        ArgumentChecker.throwIfNull(nodeView);
        if (label_ == null) {
            throw new IllegalStateException("Can't call before createControl(Composite) called."); //$NON-NLS-1$
        }
        Property property = nodeView.findProperty(sgfType_);
        if (property == null) {
            label_.setText(empty_);
            return;
        }
        updateImpl(property);
        label_.setVisible(true);
    }
    
    private void updateImpl(Property property) {
        String[] texts = property.getStrings();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < texts.length; ++i) {
        	for (GiEnum giEnum : giEnums_) {
                texts[i] = giEnum.replace(texts[i]);
        	}
            sb.append(texts[i]);
            if (i != 0) {
                sb.append(Strings.LINE_SEPARATOR);
            }
        }
        String old = label_.getText();
        String now = sb.toString();
        if (!old.equals(now)) {
            label_.setText(sb.toString());
            label_.pack();
        }
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#getSgfType()
     */
    public SgfId getSgfId() {
        return sgfType_;
    }

    /**
     * @param pattern
     * @param value2
     */
    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull(giEnum);
        if (!giEnum.getSgfType().equals(sgfType_)) {
            throw new IllegalArgumentException();
        }
        
        giEnums_.add(giEnum);
        
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.gi.GiFormula#setLabel(java.util.Properties)
     */
    public void setLabel(Properties properties) {
        empty_ = GiItem.convert(empty_, properties);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.gi.GiFormula#getControl()
	 */
	public Control getControl() {
		return label_;
	}

}
