/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.MessageResource;
import org.unitarou.swt.Layouts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.view.jface.ann.GameInfoAnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.RootAnnotationPanel;

/**
 * ՁuȊOv̏ԁEݒ\plłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ControllerPanel implements Adaptable, WidgetContainer {
    
    /** uǖʐv*/
    static private final MessageResource LB_MOVE
    		= new MessageResource(ControllerPanel.class, "lbMove"); //$NON-NLS-1$

    /** u΋Ǐv*/
    static private final MessageResource LB_GAME
    		= new MessageResource(ControllerPanel.class, "lbGame"); //$NON-NLS-1$
 
    /** uǗv*/
    static private final MessageResource LB_ROOT
    		= new MessageResource(ControllerPanel.class, "lbRoot"); //$NON-NLS-1$


    private final GameChooserPanel gameChooserPanel_;
	private final RootGameTreePanel rootGameTreePanel_;
	private final RootAnnotationPanel rootAnnotationPanel_;
	private final GameInfoAnnotationPanel gameInfoAnnotationPanel_;
    /**
     * {@link #gameChooserPanel_}Ȃǂi[܂B 
     */
    private CTabFolder tabFolder_;
	private final Adapter adapter_;
	

	/**
     * 
     */
    public ControllerPanel() {
        super();
        gameChooserPanel_ = new GameChooserPanel();
        rootGameTreePanel_  = new RootGameTreePanel();
        rootAnnotationPanel_ = new RootAnnotationPanel();
        gameInfoAnnotationPanel_ = new GameInfoAnnotationPanel();
        tabFolder_ = null;
        
        adapter_ = new Adapter();
    }


    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

	/**
	 * Rg[yC쐬܂B
	 * Rg[yC̏iCollection`ɂGameZN^[ŁA
	 * i̓Q[́A
	 * i̓m[ḧꗗ\܂B
	 * ŉi͊em[hłNoteComment\܂B
	 * AAŉi̔1:4:2łB
	 */
    public Control createContents(Composite parent) {
	    Composite panel = new Composite(parent, SWT.NONE);
	    panel.setLayout(Layouts.createForm(0,0,0));
	    
	    Control chooserPanel = gameChooserPanel_.createContents(panel);
	    FormData data = Layouts.createSpreadFormData(0);
	    data.bottom = null;
	    chooserPanel.setLayoutData(data);
	    
	    Control gamePanel = createGameTabFolder(panel);
	    data = Layouts.createSpreadFormData(0);
	    data.top = new FormAttachment(chooserPanel);
	    gamePanel.setLayoutData(data);
	    return panel;
	}	
	
	
    /**
     * @param panel
     * @return
     */
    private Control createGameTabFolder(Composite parent) {
        tabFolder_ = new CTabFolder(parent, SWT.TOP | SWT.BORDER);
        Display display = tabFolder_.getDisplay();
        tabFolder_.setForeground(display.getSystemColor(SWT.COLOR_WIDGET_NORMAL_SHADOW));
        tabFolder_.setSelectionBackground(
                new Color[] {
                        	display.getSystemColor(SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW),
                        	display.getSystemColor(SWT.COLOR_WIDGET_BACKGROUND)},
                new int[]{100},
                true);
        
        CTabItem item;
        item = new CTabItem(tabFolder_, SWT.NONE);
        item.setControl(rootGameTreePanel_.createContents(tabFolder_));
        item.setText(LB_MOVE.get());
        tabFolder_.setSelection(item);
        
        item = new CTabItem(tabFolder_, SWT.NONE);
        item.setControl(gameInfoAnnotationPanel_.createContents(tabFolder_));
        item.setText(LB_GAME.get());
        
        item = new CTabItem(tabFolder_, SWT.NONE);
        item.setControl(rootAnnotationPanel_.createContents(tabFolder_));
        item.setText(LB_ROOT.get());

        return tabFolder_;
    }

	/**
	 * ̃pl̍ŏʂ̃Rg[Ԃ܂B
	 * @return
	 */
	public Control getControl() {
		return tabFolder_;
	}

    /* (non-Javadoc)
     * @see org.unitarou.swt.ControlCreatable#dispose()
     */
    public void dispose() {
        gameChooserPanel_.dispose();
        rootGameTreePanel_.dispose();
        rootAnnotationPanel_.dispose();
        gameInfoAnnotationPanel_.dispose();
    }

    private class Adapter extends TieredModelEventNotifier {
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
            return new Adaptable[]{
                    gameChooserPanel_, 
                    rootGameTreePanel_,
                    rootAnnotationPanel_,
                    gameInfoAnnotationPanel_
                    };
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        @Override
		public void setEventBroker(EventBroker eventBroker) {
        	ArgumentChecker.throwIfNull(eventBroker);
        	eventBroker_.removeView(ControllerPanel.this);
        	eventBroker_ = eventBroker;
            eventBroker_.addView(ControllerPanel.this);
            super.setEventBroker(eventBroker);
        }
    }
}
