/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.Layouts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/**
 * CollectionGameIZN^[plłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GameChooserPanel implements	Adaptable, WidgetContainer {
	
	/** u{0}Fv*/
	static private final MessageResource LB_GAME 
			= new MessageResource(GameChooserPanel.class, "lbGame"); //$NON-NLS-1$
   
	/** u{0}ҏWv*/
	static private final MessageResource LB_EDIT
			= new MessageResource(GameChooserPanel.class, "lbEdit"); //$NON-NLS-1$

	
	private EventBroker eventBroker_;
	private CollectionEditor collectionEditor_;
	
	/**
	 * {@link Collection}
	 * e{@link org.unitarou.sgf.RootGameTree}IR{{bNXłB
	 */
	private Combo gameCombo_;
	
	private Label label_;
	/**
	 * ̕ҏWEҏW[h߂`FbN{^łB
	 */
	private Button checkButton_;
	
	/**
	 * ̃R|[lg̃A_v^[łB
	 */
	private final Adapter adapter_;

	/**
     * 
     */
    public GameChooserPanel() {
        super();
        eventBroker_ = EventBroker.NULL_BROKER;
        collectionEditor_ = null;
        gameCombo_ = null;
        label_ = null;
        checkButton_ = null;
        adapter_ = new Adapter();
    }
 
    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.WidgetContainer#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull(parent);

        Composite frame = new Composite(parent, SWT.NONE);
        frame.setLayout(new FillLayout(SWT.VERTICAL));

        Composite chooserComposte = new Composite(frame, SWT.NONE);
        chooserComposte.setLayout(Layouts.createForm(0, 0, 0));
        createLabel(chooserComposte);
        gameCombo_ = createCombo(chooserComposte, label_);
        createEditCheckButton(frame);
        return frame;
    }
    
    /**
     * parenteɂx쐬܂B
     * 
     * @param parent x̐eR|[lg
     * @retrun 쐬ꂽx 
     */
    private void createLabel(Composite parent) {
        label_ = new Label(parent, SWT.CENTER);
        FormData formData = Layouts.createSpreadFormData(0);
        formData.top = null;
        formData.right = null;
        label_.setLayoutData(formData);
    }

    /**
     * {@link Collection}̊e{@link org.unitarou.sgf.RootGameTree}I
     * R{{bNX쐬܂B
     * 
     * @param parent R{{bNX̐eR|[lg
     * @param left R{{bNX̍̃CX^XBFormLayoutł邽߂ɕKvB
     * @return 쐬ꂽR{{bNX
     */
    private Combo createCombo(Composite parent, Control left) {
        Combo gameCombo = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
        gameCombo.addSelectionListener(new SelectionAdapter() {
            @Override
			public void widgetSelected(SelectionEvent e) {
                fireGameChangeEvent();
            }
        });
        //TODO ReLXgɓ
        gameCombo.setVisibleItemCount(10);

        FormData formData = Layouts.createSpreadFormData(0);
        formData.left = new FormAttachment(left);
        gameCombo.setLayoutData(formData);

        return gameCombo;
    }
    
    /**
     * ̕ҏWEҏW[h߂`FbN{^쐬܂B
     * 
     * @param parent et[
     * @return 쐬`FbN{^
     */
    private void createEditCheckButton(Composite parent) {
    	checkButton_ = new Button(parent, SWT.CHECK | SWT.FLAT);
    	checkButton_.addSelectionListener(new SelectionAdapter() {
            @Override
			public void widgetSelected(SelectionEvent e) {
                fireEditModeChageEvent(checkButton_.getSelection());
            }            
        });
    }


    /* (non-Javadoc)
     * @see org.unitarou.swt.ControlCreatable#dispose()
     */
    public void dispose() {
        eventBroker_ = EventBroker.NULL_BROKER;
        gameCombo_.dispose();
        checkButton_.dispose();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventHandler(org.unitarou.yukinoshita.events.ModelEventHandler)
     */
    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull(eventBroker);
        eventBroker_ = eventBroker;
        eventBroker_.addView(this);
    }
    
    
	/**
	 * {@link GameChangeEvent}̔ʒm܂B
	 */
	private void fireGameChangeEvent() {
		GameChangeCommand command = new GameChangeCommand(gameCombo_.getSelectionIndex());
		eventBroker_.executeCommand(command);
	}
	
	
	/**
	 * {@link GameChangeEvent}̔ʒm܂B
	 */
	private void fireEditModeChageEvent(boolean selected) {
		eventBroker_.executeCommand(new ChangeEditModeCommand(selected));
	}
	
	
	/**
	 * ̃R|[lgA_v^[W߂TuNXłB
	 */
	private class Adapter 
			implements ModelEventNotifier, 
						 ControllerStatusMonitor, 
						 CollectionMonitor, 
						 GameMonitor, 
						 GameInfoNodeMonitor 
						  
	{
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(GameChooserPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(GameChooserPanel.this);
        }
        
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			checkButton_.setSelection(isEditMode);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}

		/* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
         */
        public void update(CollectionEditor collectionEditor) {
    	    ArgumentChecker.throwIfNull(collectionEditor);
    	    collectionEditor_ = collectionEditor;
    	    RootGameTreeLabelProvider provider = getLabelProvider();
    	    
    	    Collection collection = collectionEditor_.getCollection();
    	    String[] items = new String[collection.size()];
    	    if (collection.get(0).getGameType().equals(GameType.DRILL)) {
        	    for (int i = 0; i < items.length; ++i) {
        	        items[i] = provider.getLabel(collection.get(0));
        	    }
    	    	gameCombo_.setEnabled(false);
    	    	
    	    } else {
        	    for (int i = 0; i < items.length; ++i) {
        	        items[i] = makeRgtLabel(provider, i, collection.get(i));
        	    }
    	    	gameCombo_.setEnabled(true);
    	    }
    	    
    	    gameCombo_.setItems(items);
    	    if (0 < items.length) {
    	        gameCombo_.select(collectionEditor_.getActiveGameIndex());
    	    }
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			ArgumentChecker.throwIfNull(gameMediator);
			String name = gameMediator.getGameType().displayName();
	    	checkButton_.setText(LB_EDIT.get(name));
	    	label_.setText(LB_GAME.get(name));
	    	
	    	final int rgtIndex = collectionEditor_.getActiveGameIndex();
	    	RootGameTree rgt = gameMediator.getRootGameTree();
			RootGameTreeLabelProvider provider = getLabelProvider();
			gameCombo_.setItem(rgtIndex, makeRgtLabel(provider, rgtIndex, rgt));
			gameCombo_.select(rgtIndex);
	    	label_.getParent().layout(true, true);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor#gameInfoChanged(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void gameInfoChanged(NodeView nodeView) {
			RootGameTreeLabelProvider provider = getLabelProvider();
    	    Collection collection = collectionEditor_.getCollection();
    	    String[] items = new String[collection.size()];
    	    if (collection.get(0).getGameType().equals(GameType.DRILL)) {
    	    	if (collectionEditor_.getActiveGameIndex() != 0) {
    	    		return;
    	    	}
        	    for (int i = 0; i < items.length; ++i) {
        	        items[i] = provider.getLabel(collection.get(0));
        	    }
    	    	gameCombo_.setEnabled(false);
    	    	
    	    } else {
    	    	gameCombo_.setItem(
    	    			collectionEditor_.getActiveGameIndex(),
    	    			makeRgtLabel(provider, 
    	    					collectionEditor_.getActiveGameIndex(), 
    	    					collectionEditor_.getActiveGame().getRootGameTree()));
    	    }
    	    if (0 < items.length) {
    	        gameCombo_.select(collectionEditor_.getActiveGameIndex());
    	    }
		}

		
		private String makeRgtLabel(RootGameTreeLabelProvider provider, int index, RootGameTree rgt) {
	        StringBuilder sb = new StringBuilder();
	        sb.append(index + 1).append(':');
	        sb.append(provider.getLabel(rgt));
	        return sb.toString();
		}
		
		private RootGameTreeLabelProvider getLabelProvider() {
    	    Collection collection = collectionEditor_.getCollection();
    	    return Yukinoshita.context().getProvider(
    	                RootGameTreeLabelProvider.class, collection);
		}
	}
}
