/* 
 * Copyright 2003-2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;


import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.swt.USashForm;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.view.ModelFrame;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;

/**
 * PComposite̒ɑ΋ǗpViewŜ\܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class GameSingleFrame implements ModelFrame, WidgetContainer, Adaptable {
	
	/**
	 * Rg[̕肷ReLXgL[łB
	 * ftHgł250pxłB
	 */
	static private final IntContextValue CTRL_WIDTH 
			= new IntContextValue(GameSingleFrame.class, "ctrlWidth", 0, 250, 1000); //$NON-NLS-1$
    
	
	
    /** ՂƃAQn}AȊȌX̃m[h\郁CplłB*/
	private final MainViewPanel mainViewPanel_;

    /** ՁuȊOv̏ԁEݒ\plłB*/
	private final ControllerPanel controllerPanel_;
	
	/**
	 * {@link #mainViewPanel_}{@link #controllerPanel_}
	 * i[Sasht[łB
	 */
	private USashForm frame_;

	/** ̃CX^XqAdapterble̔złB */
	private final Adaptable[] adaptables_;
	
	private final Notifier notifier_;
	
	private final Adapter adapter_;
	
	/**
	 * 
	 */
	public GameSingleFrame() {
		super();
		mainViewPanel_ = new MainViewPanel();
		controllerPanel_ = new ControllerPanel();
		frame_ = null;
		adaptables_ = new Adaptable[]{this, mainViewPanel_, controllerPanel_};
		notifier_ = new Notifier();
		adapter_ = new Adapter();
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(adapter_)){
            return adapter_;
        }
        return null;
	}

	/**
	 * `̍̌ՃyC쐬܂B
	 */
	public Control createContents(Composite parent) {
		frame_ = WidgetFactory.createUSashForm(parent, SWT.HORIZONTAL);
	    mainViewPanel_.createContents(frame_);		
		controllerPanel_.createContents(frame_);

		CurrentContext context = Yukinoshita.context().getCurrent(null);
		int width = context.getInteger(CTRL_WIDTH);
		frame_.setWeights(new int[] {1, -width});
		frame_.setDragMinimums(new int[]{100, CTRL_WIDTH.minInt()});
		return frame_;
	}

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        mainViewPanel_.dispose();
        controllerPanel_.dispose();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
     */
    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull(eventBroker);
        notifier_.setEventBroker(eventBroker);
    }

    private class Notifier extends TieredModelEventNotifier {
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
            return adaptables_;
        }
        
    }

    
    private class Adapter implements ModelEventNotifier, LayoutMonitor {
    	
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		public void setEventBroker(EventBroker eventBroker) {
			ArgumentChecker.throwIfNull(eventBroker);
			eventBroker_.removeView(GameSingleFrame.this);
			eventBroker_ = eventBroker;
			eventBroker_.addView(GameSingleFrame.this);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#defaultLayout()
		 */
		public void defaultLayout() {
			frame_.setWeights(new int[] {1, -CTRL_WIDTH.defaultInt()});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#loadLayout()
		 */
		public void loadLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int width = context.getInteger(CTRL_WIDTH);
			frame_.setWeights(new int[] {1, -width});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#saveLayout()
		 */
		public void saveLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int width = controllerPanel_.getControl().getSize().x;
			context.setInteger(CTRL_WIDTH.id(), width);
		}
    }
} 
