/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/**
 * Select, Setup, MoveȂǂ̕ҏW̃Xe[^XƑΉActionǗNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class HandlerStatusActions 
		implements /*ModelEventNotifier,*/ Adaptable/*, ControllerStatusMonitor*/ {
    
    private class StatusChangeAction extends Action {
        private final HandlerPhase handlerStatus_;
        private StatusChangeAction(HandlerPhase handlerStatus) {
            super(handlerStatus.displayName(), IAction.AS_RADIO_BUTTON);
            assert handlerStatus != null;
            handlerStatus_ = handlerStatus;
            setId(handlerStatus.displayName());
            setEnabled(false);
        }
        
        /* (non-Javadoc)
         * @see org.eclipse.jface.action.IAction#run()
         */
        @Override
		public void run() {
            if (isChecked()) {
            	eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(handlerStatus_));
            }
        }
    }
    
    private EventBroker eventBroker_;
    
    /** ^[{@link HandlerPhase}A{@link StatusChangeAction}]*/
    private Map<HandlerPhase, StatusChangeAction> actionMap_;
    
    private final Adapter adapter_;
    /**
     * 
     */
    public HandlerStatusActions() {
        super();
        eventBroker_ = EventBroker.NULL_BROKER;
        actionMap_ = new HashMap<HandlerPhase, StatusChangeAction>();
        adapter_ = new Adapter();
    }
    

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    
    public Action[] getActions() {
        // statusɑΉaction̂ݑI
        StateHandler stateHandler = eventBroker_.getCurrentStateHander();
        if (stateHandler == null) {
            return new Action[0];
        }
        HandlerPhase[] phases = stateHandler.getHandlerPhases();
        List<StatusChangeAction> list = new ArrayList<StatusChangeAction>(phases.length);
        for (int i = 0; i < phases.length; ++i) {
            list.add(getOrMakeAction(phases[i])); 
        }
        return  list.toArray(new Action[list.size()]);
    }

    /**
     * @param eventBroker
     */
    public void setEventBroker(EventBroker eventBroker) {
        adapter_.setEventBroker(eventBroker);
    }


    
    private StatusChangeAction getOrMakeAction(HandlerPhase handlerPhase) {
        StatusChangeAction action = actionMap_.get(handlerPhase);
        if (action == null) {
            action = new StatusChangeAction(handlerPhase);
            actionMap_.put(handlerPhase, action);
        }
        return action;
    }
    
    private class Adapter implements ModelEventNotifier, ControllerStatusMonitor {

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(HandlerStatusActions.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(HandlerStatusActions.this);
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            // USANVDisableɂ
            for (Iterator ip = actionMap_.values().iterator(); ip.hasNext(); ){
                StatusChangeAction action = (StatusChangeAction)ip.next();
                action.setEnabled(false);
                action.setChecked(false);
            }
            
            // ݓ\ȃANV̂Enabledɂ
            StateHandler stateHandler = eventBroker_.getCurrentStateHander();
            if (stateHandler == null) {
                return;
            }
            HandlerPhase[] phases = stateHandler.getHandlerPhases();
            for (int i = 0; i < phases.length; ++i) {
                getOrMakeAction(phases[i]).setEnabled(true);
            }
            
            // ŏ̃ANVIB
            if (phases.length != 0) {
                StatusChangeAction select = actionMap_.get(phases[0]);
                select.setChecked(true);
            }
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase phase) {
            // statusɑΉaction̂ݑI
            StateHandler stateHandler = eventBroker_.getCurrentStateHander();
            if (stateHandler == null) {
                return;
            }
            HandlerPhase[] phases = stateHandler.getHandlerPhases();
            for (int i = 0; i < phases.length; ++i) {
            	StatusChangeAction action = getOrMakeAction(phases[i]);
            	action.setChecked(phase.equals(phases[i]));
            }
        }
    }
}
