/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoGraphicalBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.DrillEditorStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.GameViewStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.ProblemViewStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.EditorStateHandlerVer1;
import org.unitarou.yukinoshita.view.jface.dr.DrillViewerPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;

/**
 * ՂƃAQn}AȊȌX̃m[h\郁CplłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class MainViewPanel implements Adaptable, WidgetContainer {
    
	/**
	 * Rg[̕肷ReLXgL[łB
	 * ftHgł250pxłB
	 */
	static private final IntContextValue STATUS_HEIGHT 
			= new IntContextValue(MainViewPanel.class, "statusWidth", 0, 25, 120); //$NON-NLS-1$

    /**
     * {@link #boardPanel_}{{@link #statusPanel_}
     * {@link #drillViewerPanel_}̐eƂȂt[łB 
     */
    private Composite mainFrame_;
    
    /**
     * {@link #mainFrame_}̃CAEgłB
     * {@link #boardPanel_}{{@link #statusPanel_}
     * {@link #drillViewerPanel_}؂ւ邽߂ɕێ܂B 
     */
    private final StackLayout stackLayout4MainFrame_;
    
    private USashForm boardFrame_;
    private final IgoBoardPanel boardPanel_;
    private final NodeStatusPanel statusPanel_;
    
    private final DrillViewerPanel drillViewerPanel_;
    private Control drillViewerControl_;
    
    private final Adapter adapter_;
    
    /**
     * 
     */
    public MainViewPanel() {
        super();
        mainFrame_ = null;
        stackLayout4MainFrame_ = new StackLayout();
        boardPanel_ = new IgoGraphicalBoardPanel();
        boardFrame_ = null;
        drillViewerPanel_ = new DrillViewerPanel();
        drillViewerControl_ = null;
        statusPanel_ = new NodeStatusPanel();
        adapter_ = new Adapter();
    }

    /**
     * {@link ModelEventNotifier}w肷ƗLȃCX^XԂ܂B
     * 
     * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        mainFrame_ = new Composite(parent, SWT.NONE);
        mainFrame_.setLayout(stackLayout4MainFrame_);
        boardFrame_ = WidgetFactory.createUSashForm(mainFrame_, SWT.VERTICAL);
        boardPanel_.createContents(boardFrame_);
        statusPanel_.createContents(boardFrame_);
		drillViewerControl_ = drillViewerPanel_.createContents(mainFrame_);

		CurrentContext context = Yukinoshita.context().getCurrent(null);
		int height = context.getInteger(STATUS_HEIGHT);
		boardFrame_.setWeights(new int[] {1, -height});
        return mainFrame_;
    }
    

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        boardPanel_.dispose();
        drillViewerPanel_.dispose();
        statusPanel_.dispose();
    }
    
    
    /**
     * ̃NX̃A_v^[łB
     */
    private class Adapter extends TieredModelEventNotifier 
    		implements GameMonitor, CollectionMonitor, ControllerStatusMonitor, LayoutMonitor 
    {
    	private EventBroker eventBroker_;
        private final Adaptable[] adaptables_;
        private Collection collection_;
        private boolean isEditMode_;
        
        public Adapter() {
            super();
            eventBroker_ = EventBroker.NULL_BROKER;
            adaptables_ = new Adaptable[]{boardPanel_, drillViewerPanel_, statusPanel_};
            collection_ = null;
            isEditMode_ = false;
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
            return adaptables_;
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        @Override
		public void setEventBroker(EventBroker eventBroker) {
        	ArgumentChecker.throwIfNull(eventBroker);
        	eventBroker_.removeView(MainViewPanel.this);
        	eventBroker_ = eventBroker;
        	eventBroker_.addView(MainViewPanel.this);
        	
            eventBroker.register(GameType.GAME, false, new GameViewStateHandler(boardPanel_));
            eventBroker.register(GameType.GAME, true, new EditorStateHandlerVer1(boardPanel_));
            eventBroker.register(GameType.PROBLEM, false, new ProblemViewStateHandler(boardPanel_));
            eventBroker.register(GameType.PROBLEM, true, new EditorStateHandlerVer1(boardPanel_));
            eventBroker.register(GameType.DRILL, true, new DrillEditorStateHandler(boardPanel_));

            super.setEventBroker(eventBroker);
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
		 */
		public void update(CollectionEditor collectionEditor) {
			ArgumentChecker.throwIfNull(collectionEditor);
			collection_ = collectionEditor.getCollection();
			update();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			update();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
		 */
		public void setEditMode(boolean isEditMode) {
			isEditMode_ = isEditMode;
			update();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
		 */
		public void changeHandlerPhase(HandlerPhase phase) {
			// Ȃ
		}
		
		private void update() {
			if (!isEditMode_) {
				stackLayout4MainFrame_.topControl = boardFrame_;
			} else 	if (GameType.DRILL.equals(collection_.get(0).getGameType())) {
				stackLayout4MainFrame_.topControl = drillViewerControl_;
			} else {
				stackLayout4MainFrame_.topControl = boardFrame_;
			}
			stackLayout4MainFrame_.topControl.getParent().layout();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#defaultLayout()
		 */
		public void defaultLayout() {
			boardFrame_.setWeights(new int[] {1, -STATUS_HEIGHT.defaultInt()});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#loadLayout()
		 */
		public void loadLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int height = context.getInteger(STATUS_HEIGHT);
			boardFrame_.setWeights(new int[] {1, -height});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#saveLayout()
		 */
		public void saveLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int height = statusPanel_.getControl().getSize().y;
			context.setInteger(STATUS_HEIGHT.id(), height);
		}
    }
}
