/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.dr.DrillEditorPanel;
import org.unitarou.yukinoshita.view.jface.ns.NodeSelectorPanel;
import org.unitarou.yukinoshita.view.jface.pa.ProblemActionPanel;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/**
 * NodeList𐧌䂷plłB
 * ҏW\ĂƂ{@link org.unitarou.yukinoshita.view.jface.ns.NodeSelectorPanel}
 * lĂƂ{@link org.unitarou.yukinoshita.view.jface.pa.ProblemActionPanel}
 * WҏWĂƂ{@link org.unitarou.yukinoshita.view.jface.dr.DrillEditorPanel}
 * \܂B܂ANCY`̖肪oꍇ́Ap̃pl\܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NodeListControllerPanel implements Adaptable, WidgetContainer {

	/** 
	 * [{@link #makeKey}, ؂ւpl]̑gێ܂B
	 */
	private final Map<String, SelectablePanel> panelMap_;
	
	/**
	 * \؂ւ邽߁ACAEgCX^XێĂ܂B
	 */
	private StackLayout stackLayout4Node_;

	
	private GameType gameType_;
	private boolean isEditing_;

	
	private final Adapter adapter_;

	/**
     * 
     */
    public NodeListControllerPanel() {
        super();
        NodeSelectorPanel nodeSelectorPanel = new NodeSelectorPanel();
        ProblemActionPanel problemActionPanel = new ProblemActionPanel();
        DrillEditorPanel drillEditorPanel = new DrillEditorPanel();
        
        panelMap_ = new HashMap<String, SelectablePanel>();
        panelMap_.put(makeKey(GameType.GAME, false), nodeSelectorPanel);
        panelMap_.put(makeKey(GameType.GAME, true), nodeSelectorPanel);
        panelMap_.put(makeKey(GameType.PROBLEM, false), problemActionPanel);
        panelMap_.put(makeKey(GameType.PROBLEM, true), nodeSelectorPanel);
        panelMap_.put(makeKey(GameType.DRILL, true), drillEditorPanel);

        stackLayout4Node_ = null;

        gameType_ = GameType.GAME;
        isEditing_ = false;

        adapter_ = new Adapter();
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
	    Composite nodePanel = new Composite(parent, SWT.NONE);
	    stackLayout4Node_ = new StackLayout();
	    nodePanel.setLayout(stackLayout4Node_);

	    for(SelectablePanel panel : panelMap_.values()) {
	    	panel.createContents(nodePanel);
	    }
	    SelectablePanel panel = panelMap_.get(makeKey());
	    stackLayout4Node_.topControl = (panel != null) ? panel.getControl() : null;
		return nodePanel;
    }


	/* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
	    for(SelectablePanel panel : panelMap_.values()) {
	    	panel.dispose();
	    }
    }

    private void updateNodePanel() {
	    SelectablePanel panel = panelMap_.get(makeKey());
	    if (panel != null) {
		    stackLayout4Node_.topControl = panel.getControl();
		    panel.getControl().getParent().layout();
	    } else {
	    	stackLayout4Node_.topControl = null;
	    }
    }

    /**
     * {@link #panelMap_}pgameTypeisEditingȂL[쐬ĕԂ܂B
     * 
     * @param gameType
     * @param isEditing
     * @return gameTypeisEditingł{@link #panelMap_}p̃L[
     */
    private String makeKey(GameType gameType, boolean isEditing) {
    	return gameType + String.valueOf(isEditing);
    }

    /**
     * ݂{@link #gameType_}{@link #isEditing_}{@link #panelMap_}p̃L[Ԃ܂B
     * @return {@link #panelMap_}p̃L[B
     */
    private String makeKey() {
		return makeKey(gameType_, isEditing_);
	}

    private class Adapter extends TieredModelEventNotifier
    		implements GameMonitor, ControllerStatusMonitor  
    {
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
         */
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull(gameMediator);
            gameType_ = gameMediator.getGameType();
            updateNodePanel();
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
        	return panelMap_.values().toArray(new Adaptable[panelMap_.size()]);
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        @Override
		public void setEventBroker(EventBroker eventBroker) {
        	ArgumentChecker.throwIfNull(eventBroker);
        	eventBroker_.removeView(NodeListControllerPanel.this);
        	eventBroker_ = eventBroker;
            eventBroker_.addView(NodeListControllerPanel.this);
            super.setEventBroker(eventBroker);
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            isEditing_ = isEditMode;
            updateNodePanel();
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerStatus(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase status) {
            // do nothing
        }
    }
}
