/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * Ƃ肠ł̓AQn}ƕҏW[h\Ă܂B
 * TODO }EX{^ƃCxgRtACR\B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NodeStatusPanel implements Adaptable, WidgetContainer {
    
	/**
	 * ̃pl̍ŏʂ̃t[łB
	 */
	private Composite composite_;
	
    private Label whiteCaptured_;
    private Label blackCaptured_;
    private ToolBarManager toolBarManager_;
    
    private final HandlerStatusActions handlerStatusActions_;
    private final Adapter adapter_;

    /**
     * 
     */
    public NodeStatusPanel() {
        super();
        composite_ = null;
        whiteCaptured_ = null;
        blackCaptured_ = null;
        
        handlerStatusActions_ = new HandlerStatusActions();
        adapter_ = new Adapter();
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        composite_ = new Composite(parent, SWT.NONE);
        composite_.setLayout(new RowLayout());
        
        Label label = new Label(composite_, SWT.LEFT);
        label.setImage(NodeImage.WHITE.get());
        whiteCaptured_ = new Label(composite_, SWT.LEFT);
        
        label = new Label(composite_, SWT.LEFT);
        label.setImage(NodeImage.BLACK.get());
        blackCaptured_ = new Label(composite_, SWT.LEFT);
        toolBarManager_ = new ToolBarManager(SWT.FLAT);
        toolBarManager_.createControl(composite_);
        return composite_;
    }
    
	/** 
	 * ̃pl̍ŏʂ̃Rg[Ԃ܂B
	 * @return
	 */
	public Control getControl() {
		return composite_;
	}

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        // TODO Auto-generated method stub
        
    }

    /** 
     * ҏW[h̍ڂXV܂B
     */
    private void updateToolBar() {
        toolBarManager_.removeAll();
        Action[] actions = handlerStatusActions_.getActions();
        for (int i = 0; i < actions.length; ++i) {
            toolBarManager_.add(actions[i]);
        }
        if (actions.length != 0) {
            actions[0].setEnabled(true);
            actions[0].setChecked(true);
        }
        toolBarManager_.update(false);
        toolBarManager_.getControl().getParent().layout();
    }

    
    private class Adapter 
    		implements CollectionMonitor,
    					NodeMonitor, 
    					ControllerStatusMonitor,
    					ModelEventNotifier 
    {
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
         */
        public void update(CollectionEditor collectionEditor) {
            updateToolBar();            
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
         */
        public void currentChanged(NodeView nodeView) {
        	ArgumentChecker.throwIfNull(nodeView);
            boolean needsLayout = false;
            String newWc = String.valueOf(nodeView.getCaptured(SgfColor.WHITE).size());
            if (!newWc.equals(whiteCaptured_.getText())) {
                whiteCaptured_.setText(newWc);
                needsLayout = true;
            }
            String newBc = String.valueOf(nodeView.getCaptured(SgfColor.BLACK).size());
            if (!newBc.equals(blackCaptured_.getText())) {
                blackCaptured_.setText(newBc);
                needsLayout = true;
            }
            
            if (needsLayout) {
                whiteCaptured_.getParent().layout();
            }
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            updateToolBar();
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerStatus(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase status) {
            // Ȃ
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
        	ArgumentChecker.throwIfNull(eventBroker);
        	eventBroker_.removeView(NodeStatusPanel.this);
    		eventBroker_ = eventBroker;
            eventBroker_.addView(NodeStatusPanel.this);
            handlerStatusActions_.setEventBroker(eventBroker_);
            updateToolBar();
        }
    }
}
