/*  
 * Copyright 2003-2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.CommandFactory;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * tⳂƃ\PanelNXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class NoteMemoPanel implements Adaptable, WidgetContainer {
    
	/** utⳁv*/
	static private final MessageResource LB_NOTE 
			= new MessageResource(NoteMemoPanel.class, "lbNote"); //$NON-NLS-1$
	
	private final boolean showNote_;
	
	private Composite frame_;
	
	/**
	 * \ΏۂƂȂĂ{@link NodeView}ێ܂B
	 */
	private NodeView nodeView_;
	
	private Text nodeName_;
	
	private Text comment_;
	
	private EventBroker eventBroker_;
	
	private final Adapter adapter_;
	
    /**
     * (`Monitor)ɂ郂f̕ύXʒmɊÂ
     * WidgetύXĂ鎞trueێtOłB
     * ltrue̊ԂWidget̕ύXfɒʒm
     * {@link #update(String, SgfId)}ׂ͂Ė܂B
     */
    private boolean isModelUpdateMode_;

	
	/**
	 * <code>new NoteMemoPanel(true)</code>ƓłB
	 */
	public NoteMemoPanel() {
		this(true);
	}
	
	/**
	 * vCRXgN^łB
	 * @param showNote tⳂ\ꍇtrueZbgB
	 */
	public NoteMemoPanel(boolean showNote) {
		super();
		frame_ = null;
		nodeView_ = null;
		showNote_ = showNote;
		eventBroker_ = EventBroker.NULL_BROKER;
		adapter_ = new Adapter();
		isModelUpdateMode_ = false;
	}

	/**
	 * {@link NodeMonitor}{@link ControllerStatusMonitor}ɓKĂ܂B
	 *  
     * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }
	

    /**
     * tⳂƃ\Widget쐬ĕԂ܂B
     */
	public Control createContents(Composite parent) {
	    frame_ = new Composite(parent, SWT.NONE);
		frame_.setLayout(new FormLayout());

		createNote(frame_);
		createComment(frame_);
		return frame_;
	}
	
	/**
	 * tⳕframeeƂč\܂B 
	 */
	private void createNote(Composite parent) {
		Label label = new Label(parent, SWT.NONE);
		label.setText(LB_NOTE.get());
		label.setVisible(showNote_);

		nodeName_ = new Text(parent, SWT.BORDER);
		nodeName_.setEditable(false);
		nodeName_.addFocusListener(new FocusAdapter() {
            @Override
			public void focusLost(FocusEvent e) {
            	update(nodeName_.getText(), SgfId.NODENAME);
            }
		});
		nodeName_.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkAndUpdate(nodeName_.getText(), SgfId.NODENAME);
			}
		});

		nodeName_.setVisible(showNote_);
		
		FormData fdLabel = new FormData();
		fdLabel.left = new FormAttachment(0, 2);
		fdLabel.top = new FormAttachment(0, 2);
		label.setLayoutData(fdLabel);
		
		FormData fdNodename = new FormData();
		fdNodename.left = new FormAttachment(label, 2);
		fdNodename.top = new FormAttachment(0, 2);
		fdNodename.right = new FormAttachment(100, 2);
		nodeName_.setLayoutData(fdNodename);
	}
	
	/**
	 * frameeƂč\܂B
	 */
	private void createComment(Composite parent) {
		comment_ = new Text(parent, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
		FormData fdComment = new FormData();
		fdComment.left = new FormAttachment(0, 0);
		fdComment.top = new FormAttachment(nodeName_, 2);
		fdComment.right = new FormAttachment(100, 2);
		fdComment.bottom = new FormAttachment(100, 2);
		comment_.setLayoutData(fdComment);
		comment_.setEditable(false);
		comment_.addFocusListener(new FocusAdapter() {
            @Override
			public void focusLost(FocusEvent e) {
            	update(comment_.getText(), SgfId.COMMENT);
            }
		});
		comment_.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkAndUpdate(comment_.getText(), SgfId.COMMENT);
			}
		});
	}
	
	/**
	 * ҏW[hňʈȏ㕶ɕύX𒲂ׁA
	 * ύXĂꍇ{@link #update(String, SgfId)}Ăяo܂B
	 * @param newDatum
	 * @param sgfId
	 */
	private void checkAndUpdate(String newDatum, SgfId sgfId) {
		Property property = nodeView_.getProperty(sgfId);
		String lastString = (property != null) ? property.getString() : Strings.EMPTY;

		int charLength = Yukinoshita.context().getCurrent(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE);
		if (charLength <= Strings.calcDiffSize(lastString, newDatum)) {
			update(newDatum, sgfId);
		}
	}
	
	/**
	 * newDatumNodeViewƈقȂɍXVR}hs܂B
	 * @param newDatum
	 * @param sgfId
	 */
	private void update(String newDatum, SgfId sgfId) {
		if (isModelUpdateMode_) {
			return;
		}
		UpdateProperty command	= CommandFactory.createUpdateProperty(newDatum, sgfId, nodeView_, false);
		if (command != null) {
			eventBroker_.executeCommand(command);
		}
	}
	
    /**
	 * @return
	 */
	public Control getControl() {
		return frame_;
	}

	/* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        nodeName_.dispose();
        comment_.dispose();
        eventBroker_ = EventBroker.NULL_BROKER;
    }


    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerStatus(org.unitarou.yukinoshita.view.jface.board.eh.HandlerStatus)
     */
    public void changeHandlerPhase(HandlerPhase status) {
        // TODO Auto-generated method stub
        
    }
    
    private class Adapter 
    		implements ModelEventNotifier, NodeMonitor, ControllerStatusMonitor {

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(NoteMemoPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(NoteMemoPanel.this);
        }

        /**
         * ڂm[hNodeViewɕύXɂȂƂɌĂяo܂B
         * @see org.unitarou.yukinoshita.view.monitor.NodeMonitor#currentChanged(NodeView)
         */
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull(nodeView);
            isModelUpdateMode_ = true;
            nodeView_ = nodeView;
            
            Property property;
            property = nodeView_.getProperty(SgfId.COMMENT);
            String newString;
            newString = (property == null) ? Strings.EMPTY : property.getString();
            if (!newString.equals(comment_.getText())) {
                comment_.setText(newString); 
            }
            
            property = nodeView_.getProperty(SgfId.NODENAME);
            newString = (property == null) ? Strings.EMPTY : property.getString();
            if (!newString.equals(nodeName_.getText())) {
            	nodeName_.setText(newString); 
            }
            isModelUpdateMode_ = false;
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            nodeName_.setEditable(isEditMode);
            comment_.setEditable(isEditMode);
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase phase) {
            // do nothing
        }
    }
}
