/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.swt.USashForm;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.view.jface.gi.GameInfoPanel;
import org.unitarou.yukinoshita.view.jface.gi.GameInfoPanelFactory;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;

/**
 * {@link org.unitarou.sgf.RootGameTree}ȉ̏̕\ƑS
 * Rg[łB
 * ̓Iɂ͈ȉ̃plcɘAplłB
 * <ol>
 * <li>{@link org.unitarou.yukinoshita.view.jface.gi.GameInfoPanel}</li>
 * <li>{@link org.unitarou.yukinoshita.view.jface.gm.NodeListControllerPanel}</li>
 * </ol>
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class RootGameTreePanel implements Adaptable, WidgetContainer {
	
	static private final IntContextValue INFO_HEIGHT
			= new IntContextValue(RootGameTreePanel.class, "infoHeight", 0, 100, 400); //$NON-NLS-1$
	
	private USashForm frame_;
	private GameInfoPanel gameInfoPanel_; 
	private final NodeListControllerPanel nodeListControllerPanel_;	
	

	private final Adapter adapter_;

	/**
     * 
     */
    public RootGameTreePanel() {
        super();
        gameInfoPanel_ = null;
        nodeListControllerPanel_ = new NodeListControllerPanel();
        adapter_ = new Adapter();
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
		frame_ = WidgetFactory.createUSashForm(parent, SWT.VERTICAL);

		gameInfoPanel_ = GameInfoPanelFactory.instance().createDefault();
		gameInfoPanel_.createContents(frame_);
		nodeListControllerPanel_.createContents(frame_);

		CurrentContext context = Yukinoshita.context().getCurrent(null);
		frame_.setWeights(new int[] {-context.getInteger(INFO_HEIGHT), 1});
		return frame_;
    }
    

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        if (gameInfoPanel_ != null) {
            gameInfoPanel_.dispose();
        }
    }
    

    private class Adapter extends TieredModelEventNotifier implements LayoutMonitor {
    	
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
            return new Adaptable[]{
                    gameInfoPanel_, 
                    nodeListControllerPanel_,
                    };
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        @Override
		public void setEventBroker(EventBroker eventBroker) {
        	ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(RootGameTreePanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(RootGameTreePanel.this);
            super.setEventBroker(eventBroker);
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#defaultLayout()
		 */
		public void defaultLayout() {
			frame_.setWeights(new int[] {-INFO_HEIGHT.defaultInt(), 1});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#loadLayout()
		 */
		public void loadLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int height = context.getInteger(INFO_HEIGHT);
			frame_.setWeights(new int[]{-height, 1});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#saveLayout()
		 */
		public void saveLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int height = gameInfoPanel_.getControl().getSize().y;
			context.setInteger(INFO_HEIGHT.id(), height);
		}
    }
}
