/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ns;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

import org.unitarou.jface.ImageResource;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.swt.Swts;

/**
 * {@link org.unitarou.yukinoshita.view.jface.ns.VariationSelectorPanel}
 * ω}̌\邽ߐ΂ImageƃeLXgĕ\{^łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class MoveButton {
    /**
     * ۂɕ`揈SyC^[NXłB 
     */
    private static class Painter {
        private String prefix_;
        private Image image_;
        private String postfix_;
        
        private Point prefixSp_;
        private Point imageSp_;
        private Point postfixSp_;
        private Point totalSp_;

        /**
         * `p̃p[^Zbg܂B
         * gc̓eLXg̃TCYvƂɗp܂B 
         */
        private void set(GC gc, String prefix, Image image, String postfix) {
            prefix_ = prefix;
            image_ = image;
            postfix_ = postfix;
            prefixSp_ = gc.textExtent(prefix_, SWT.DRAW_MNEMONIC);
            imageSp_ = Geometry.getSize(image_.getBounds());
            postfixSp_ = gc.textExtent(postfix_, SWT.DRAW_MNEMONIC);
            totalSp_ = Swts.add(prefixSp_, imageSp_, SWT.HORIZONTAL);
            totalSp_ = Swts.add(totalSp_, postfixSp_, SWT.HORIZONTAL);
        }
        


        /**
         * gcɕ`悵܂B
         */
        private void paint(GC gc) {
            gc.fillRectangle(0, 0, totalSp_.x, totalSp_.y);
            gc.drawText(prefix_, 0, (totalSp_.y - prefixSp_.y) / 2, SWT.DRAW_MNEMONIC);
            gc.drawImage(image_, prefixSp_.x, (totalSp_.y - imageSp_.y) / 2);
            gc.drawText(postfix_, prefixSp_.x + imageSp_.x, (totalSp_.y - postfixSp_.y) / 2, SWT.DRAW_MNEMONIC);
        }
    }
    
    /** ̃{^ۗLĂplłB*/
    private final VariationSelectorPanel variationSelectorPanel_;

    /** bvĂ{^CX^Xł */
    private Button button_;
    
    /** ̃{^̃O[vł̃CfbNXێ܂B */
    private final int index_;


    /**
     * 
     */
    public MoveButton(VariationSelectorPanel variationSelectorPanel, int index) {
        super();
        if (variationSelectorPanel == null) {
            throw new NullArgumentException("Argument(variationSelectorPanel) must not be null."); //$NON-NLS-1$
        }
        index_ = index;
        variationSelectorPanel_ = variationSelectorPanel;
        button_ = null;
    }
    
    
    public void createControl(Composite parent, int style) {
        button_ = new Button(parent, style);
        button_.addDisposeListener(new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
                disposeButtonImage();
            }
        });
        button_.addSelectionListener(new SelectionAdapter() {
            @Override
			public void widgetSelected(SelectionEvent e) {
                // `FbNOƂSelection͖B
                if (!((Button)e.widget).getSelection()) { 
                    return;
                }
                variationSelectorPanel_.variationChanged(MoveButton.this);
            }
        });
    }
    
    public void set(String prefix, ImageResource imageResource, String postfix) {
        Image image = imageResource.get();
        GC gc = new GC(button_);
        try {
            Painter p = new Painter();
            p.set(gc, prefix, image, postfix);
            disposeButtonImage();
            button_.setImage(new Image(button_.getDisplay(), p.totalSp_.x, p.totalSp_.y));
            paint(p);
        } finally {
            gc.dispose();
        }
    }
    
    
    private void paint(Painter p) {
        GC gc = new GC(button_.getImage());
        try {
            gc.setFont(button_.getFont());
            gc.setBackground(button_.getBackground());
            gc.setForeground(button_.getForeground());
            p.paint(gc);
        } finally {
            gc.dispose();
        }
    }
    

    private void disposeButtonImage() {
        if (button_ == null) {
            return;
        }
        Image image = button_.getImage();
        if ((image != null) && !image.isDisposed()) {
            image.dispose();
        }
        button_.setImage(null);
    }
    
    


    /**
     * Marks the receiver as visible if the argument is <code>true</code>,
     * and marks it invisible otherwise. 
     * <p>
     * If one of the receiver's ancestors is not visible or some
     * other condition makes the receiver not visible, marking
     * it visible may not actually cause it to be displayed.
     * </p>
     *
     * @param visible the new visibility state
     *
     * @exception SWTException <ul>
     *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
     *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
     * </ul>
     */
    public void setVisible(boolean visible) {
        button_.setVisible(visible);
    }
    
    /**
     * Sets the selection state of the receiver, if it is of type <code>CHECK</code>, 
     * <code>RADIO</code>, or <code>TOGGLE</code>.
     *
     * <p>
     * When the receiver is of type <code>CHECK</code> or <code>RADIO</code>,
     * it is selected when it is checked. When it is of type <code>TOGGLE</code>,
     * it is selected when it is pushed in.
     *
     * @param selected the new selection state
     *
     * @exception SWTException <ul>
     *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
     *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
     * </ul>
     */
    public void setSelection(boolean selected) {
        button_.setSelection(selected);
    }
    
    public int getIndex() {
        return index_;
    }
}
