/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.cmd.NodeSelectionCommand;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * m[ḧꗗXg`ŕ\plłB
 * @author unitarou &lt;boss@unitarou.org&gt;
 * @log TRACE AdapteřĂяoL^܂B
 */
public class NodeListPanel implements Adaptable, WidgetContainer {
	
	/** ̃NX̃K[łB */
	static private final Log log_s_ = LogFactory.getLog(NodeListPanel.class);
    
    private EventBroker eventBroker_;
    
    /** 
     * f̃m[hXgłB
     */
    private NodeList nodeList_;
    
	private TableViewer tableViewer_;
	
	private final Adapter adapter_;
	
	
	/**
	 * refreshtrueɂȂtOłB
	 * tOĂԂ̓Cxg𑗏o܂B
	 */
	private boolean inRefresh_;
	
	/**
     * 
     */
    public NodeListPanel() {
        super();
        eventBroker_ = EventBroker.NULL_BROKER;
        inRefresh_ = false;
        nodeList_ = null;
        tableViewer_ = null;
        adapter_ = new Adapter();
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }
    
    public Control createContents(Composite parent) {
        tableViewer_ = new TableViewer(parent, 
                						SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER | 
                						SWT.H_SCROLL | SWT.V_SCROLL);
        tableViewer_.setContentProvider(new NodeListContentProvider());
        tableViewer_.setLabelProvider(new NodeListLabelProvider());
        
        Table table = tableViewer_.getTable();
        table.setHeaderVisible(false);
        new TableColumn(table, SWT.CENTER);
        new TableColumn(table, SWT.RIGHT);
        new TableColumn(table, SWT.LEFT);
        new TableColumn(table, SWT.LEFT);
        tableViewer_.setInput(null);
        tableViewer_.addSelectionChangedListener(new ISelectionChangedListener() {
            public void selectionChanged(SelectionChangedEvent event) {
                fireNodeSelected();
            }
        });
        MouseOnGroupListener listener = new MouseOnGroupListener();
        table.addListener(SWT.MouseWheel, listener);
        table.addMouseTrackListener(listener);
        return table;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        // ł͓Ɍ㏈͕sv
    }
    
    private void packColumns() {
        TableColumn[] columns = tableViewer_.getTable().getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].pack();
        }
    }

	private void fireNodeSelected() {
	    if (inRefresh_) {
	        return;
	    }
	    int index = tableViewer_.getTable().getSelectionIndex();
	    if (index == -1) {
	    	return;
	    }
	    NodeSelectionCommand command = new NodeSelectionCommand(index);
	    eventBroker_.executeCommand(command);
	}
	
	public void refresh() {
	    inRefresh_ = true;
	    tableViewer_.getTable().setRedraw(false);
	    try {
	        int index = tableViewer_.getTable().getSelectionIndex();
	        for (int i = 0; i < nodeList_.size(); ++i) {
	        	tableViewer_.update(nodeList_.getNodeView(i), null);
	        }
	        packColumns();
	        tableViewer_.getTable().setSelection(index);
	    } finally {
		    tableViewer_.getTable().setRedraw(true);
	        inRefresh_ = false;
	    }
	}

    /**
     * }EXzC[̃CxgnhO܂B<br>
     * GroupɃ}EXƃtH[JXDAGroup̃WI{^؂ւ܂B
     */
    private class MouseOnGroupListener extends MouseTrackAdapter implements Listener {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
		 */
		public void handleEvent(Event event) {
			Table table = tableViewer_.getTable();
			table.getVerticalBar().setThumb(1);
			int index = table.getSelectionIndex();
			if (index < 0) {
				return;
			}
			if (0 < event.count) {
				index -= (event.count / 3);
				if (index < 0) {
					index = 0;
				}
			} else if (event.count < 0) {
				index -= (event.count / 3);
				if (table.getItemCount() <= index) {
					index = table.getItemCount() - 1;
					}
			}
			if (table.getSelectionIndex() != index) {
				table.setSelection(index);
				fireNodeSelected();
			}
		}
		
		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.MouseTrackListener#mouseEnter(org.eclipse.swt.events.MouseEvent)
		 */
		@Override
		public void mouseEnter(MouseEvent e) {
        	if (tableViewer_.getTable().getShell() == Display.getCurrent().getActiveShell()) {
    			tableViewer_.getTable().forceFocus();
        	}
		}
    }

    /**
	 * ̃pl󂯎CxgSĂ܂Ƃ߂NXłB
	 * TODO ̂肩
	 * TRACEEventBrokerImplōs
	 * RootGameTree؂ւƕҏWꂽƂɂȂĂ̂ŁA
	 * ׂ(bata 6ł͋NȂ)B炭NoteCommentA^낤A
	 * Ƃ肠EventBrokerImplŔCxgSăg[X郍OR[h
	 * ׂB
	 */
    private class Adapter 
    		implements GameMonitor, NodeListMonitor, NodeMonitor, ModelEventNotifier, ContextMonitor {

        private CurrentContext context_ = CurrentContext.nullContext;
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
         */
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull(gameMediator);

            context_ = gameMediator.getContext();
            NodeList newList =  gameMediator.getNodeList();
            if (newList != nodeList_) {
            	nodeList_ = newList;
            	
            } else { // ꍇRootm[hҏWꂽB
                for (int i = 0 ; i< nodeList_.size(); ++i) {
                	tableViewer_.update(nodeList_.getNodeView(i), null);
                }
            }
            if (log_s_.isTraceEnabled()){
                log_s_.trace("update(GameMediator gameMediator)" + gameMediator.toString()); //$NON-NLS-1$
            }
        }
        
        /* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeListMonitor#update(org.unitarou.yukinoshita.model.NodeView[])
		 */
		public void update(NodeView[] nodeViews) {
			ArgumentChecker.throwIfNull((Object)nodeViews);
			for (NodeView nodeView : nodeViews) {
				currentChanged(nodeView);
			}
            if (log_s_.isTraceEnabled()){
                log_s_.trace("update(NodeView[] nodeViews)" + nodeViews.toString()); //$NON-NLS-1$
            }
		}

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
         */
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull(nodeView);
            if (nodeList_ == null) {
                throw new IllegalStateException("Method must be called after #update(GameMediator) called,"); //$NON-NLS-1$
            }
            
            boolean needsColumnPack = false;
            
            // ω}̑IȂǂŕύXJnn_TāA
            // UύXn_ȍ~uE폜B
            final int lastSelectionIndex = tableViewer_.getTable().getSelectionIndex();
            int viewSize = tableViewer_.getTable().getItemCount();
            final int evalEndPos = Math.min(nodeList_.size(), viewSize);
            
            for (int i = 0; i < evalEndPos; ++i) {
            	if (nodeList_.getNodeView(i).equals(tableViewer_.getElementAt(i))) {
            		continue;
            	}
            	if (log_s_.isTraceEnabled()) {
                	log_s_.trace("Replace [" + i + ',' + evalEndPos + ')');  //$NON-NLS-1$
            	}
            	for (int j = i; j < evalEndPos; ++j) {
            		tableViewer_.replace(nodeList_.getNodeView(j), j);	
            	}

            	if (log_s_.isTraceEnabled()) {
                	log_s_.trace("Remove A [" + evalEndPos + ',' + viewSize + ')');  //$NON-NLS-1$
            	}
            	tableViewer_.remove(partOfViewItem(evalEndPos, viewSize));
            	viewSize = tableViewer_.getTable().getItemCount();
        		needsColumnPack = true;
        		break;
            }
            
            if (viewSize < nodeList_.size()) { // ViewɒǉB
            	if (log_s_.isTraceEnabled()) {
                	log_s_.trace("Add [" + viewSize + ',' + nodeList_.size() + ')');  //$NON-NLS-1$
            	}
            	tableViewer_.add(partOfModelItem(viewSize, nodeList_.size()));
        		needsColumnPack = true;
            	
            } else if (nodeList_.size() < viewSize) { // View폜B
            	if (log_s_.isTraceEnabled()) {
                	log_s_.trace("Remove B [" + nodeList_.size() + ',' + viewSize + ')');  //$NON-NLS-1$
            	}
            	tableViewer_.remove(partOfViewItem(nodeList_.size(), viewSize));
        		needsColumnPack = true;
            }

            if (needsColumnPack) {
        		packColumns();
            }

            viewSize = tableViewer_.getTable().getItemCount();
            int index = -1;
            for(int i = 0 ; i < viewSize; ++i) {
                if (nodeView.isSameNodeEntity((NodeView)tableViewer_.getElementAt(i))) {
                    index = i;
                    break;
                }
            }
            if (index == -1) {
            	index = Math.min(lastSelectionIndex, nodeList_.size() - 1);
            }
            tableViewer_.update(nodeView, null);
            tableViewer_.getTable().setSelection(index);
        	if (log_s_.isTraceEnabled()) {
                log_s_.trace("currentChanged(NodeView nodeView): Update [" + index + ']' + nodeView); //$NON-NLS-1$
        	}
        }
        
        /**
         * {@link NodeListPanel#tableViewer_}startend̈O܂ł̗vfzɂĕԂ܂B
         * @param start
         * @param end
         */
        private Object[] partOfViewItem(int start, int end) {
        	Object[] items = new Object[end - start];
        	int index = 0;
        	for (int i = start; i < end; ++i) {
        		items[index] = tableViewer_.getElementAt(i);
        		++index;
        	}
        	return items;
        }

        /**
         * {@link NodeListPanel#nodeList_}startend̈O܂ł̗vfzɂĕԂ܂B
         * @param start
         * @param end
         */
        private Object[] partOfModelItem(int start, int end) {
        	Object[] items = new Object[end - start];
        	int index = 0;
        	for (int i = start; i < end; ++i) {
        		items[index] = nodeList_.getNodeView(i);
        		++index;
        	}
        	return items;
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(NodeListPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(NodeListPanel.this);
        	if (log_s_.isTraceEnabled()) {
                log_s_.trace("setEventBroker(EventBroker eventBroker)" + eventBroker_); //$NON-NLS-1$
        	}
        }


        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ContextMonitor#attributeChanged(java.util.Set)
         */
        public void attributeChanged(Set<String> keySet) {
            ArgumentChecker.throwIfNull(keySet);
            
            boolean needsRefresh = false;
            if (keySet.contains(CoordinatesLabelProvider.class.getName())) {
            	NodeListLabelProvider provider 
            			= (NodeListLabelProvider)tableViewer_.getLabelProvider();
                CoordinatesLabelProvider newProvider 
                		= context_.getProvider(CoordinatesLabelProvider.class);
                CoordinatesLabelProvider lastProvider 
                		= provider.getProvider();

                if (!lastProvider.equals(newProvider)) {
                	provider.setProvider(newProvider);
                    needsRefresh = true;
                }
            }
            
            if (needsRefresh) {
                refresh();
            }
        	if (log_s_.isTraceEnabled()) {
                log_s_.trace("attributeChanged(Set<String> keySet)" + keySet); //$NON-NLS-1$
        	}
        }
    }
}
