/* 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ns;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.swt.USashForm;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.gm.NoteMemoPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;

/**
 * m[ḧꗗƂ̎_ł̕ω}I邱ƂŁA
 * ǖʂ\邽߂̃Rg[[łB
 * ҏW\ĂƂɕ\Rg[[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NodeSelectorPanel implements SelectablePanel, Adaptable {
	
	/**
	 * {@link #nodeListPanel_}̕\䗦(=3)łB
	 */
	static private final int LIST_RATIO = 3;
	
	/**
	 * {@link #variationSelectorPanel_}̕\䗦(=1)łB
	 */
	static private final int VARIATION_RATIO = 1;
	
	/**
	 * Rg{@link #noteMemoPanel_}̍K肵܂B
	 * ftHg150pxłB
	 */
	static private final IntContextValue COMMENT_HEIGHT
			= new IntContextValue(NodeSelectorPanel.class, "commentHeight", 0, 150, 600); //$NON-NLS-1$
    
	private USashForm frame_;
	private final NodeListPanel nodeListPanel_;
	private final VariationSelectorPanel variationSelectorPanel_;
	private final NoteMemoPanel noteMemoPanel_;
	private final Adapter adapter_;
	
	/**
	 * ̃pl̍ŏʂ{@link Control}łB
	 * {@link #createContents(Composite)}ꂽƂɕێ܂B
	 */
	private Control rootControl_;

	/**
	 * @param collectionEventHandler_
     * 
     */
    public NodeSelectorPanel() {
        super();
        frame_ = null;
        nodeListPanel_ = new NodeListPanel();
        variationSelectorPanel_ = new VariationSelectorPanel();
        noteMemoPanel_ = new NoteMemoPanel();
        adapter_ = new Adapter();
        rootControl_ = null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
    	frame_ = WidgetFactory.createUSashForm(parent, SWT.VERTICAL);
		nodeListPanel_.createContents(frame_);
		variationSelectorPanel_.createContents(frame_);
		
		//TODO ̂肩
		// TCY肵AdapterRg[ł悤ɂB
		CurrentContext context = Yukinoshita.context().getCurrent(null);
		noteMemoPanel_.createContents(frame_);
		frame_.setWeights(new int[] {LIST_RATIO, VARIATION_RATIO, -context.getInteger(COMMENT_HEIGHT)});
		rootControl_ = frame_;
		
		
	    return rootControl_;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        nodeListPanel_.dispose();
        variationSelectorPanel_.dispose();
        noteMemoPanel_.dispose();
    }
    
    /**
     * ̃EBWbg̃gbṽRg[Ԃ܂B
     * {@link #createContents(Composite)}OɌĂяoꂽꍇɂnullԂ܂B
     */
    public Control getControl() {
        return rootControl_;
    }

    private class Adapter extends TieredModelEventNotifier implements LayoutMonitor {
        private final Adaptable[] adaptables_;
    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        public Adapter() {
            super();
            adaptables_ = new Adaptable[]{
            		nodeListPanel_, 
            		variationSelectorPanel_,
            		noteMemoPanel_};
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
         */
        @Override
		protected Adaptable[] getAdaptables() {
            return adaptables_;
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		@Override
		public void setEventBroker(EventBroker eventBroker) {
			ArgumentChecker.throwIfNull(eventBroker);
			eventBroker_.removeView(NodeSelectorPanel.this);
			eventBroker_ = eventBroker;
			eventBroker_.addView(NodeSelectorPanel.this);
			super.setEventBroker(eventBroker);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#defaultLayout()
		 */
		public void defaultLayout() {
			frame_.setWeights(new int[] {LIST_RATIO, VARIATION_RATIO, -COMMENT_HEIGHT.defaultInt()});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#loadLayout()
		 */
		public void loadLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int height = context.getInteger(COMMENT_HEIGHT);
			frame_.setWeights(new int[]{LIST_RATIO, VARIATION_RATIO, -height});
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.LayoutMonitor#saveLayout()
		 */
		public void saveLayout() {
			CurrentContext context = Yukinoshita.context().getCurrent(null);
			int height = noteMemoPanel_.getControl().getSize().y;
			context.setInteger(COMMENT_HEIGHT.id(), height);
		}
    }
}
