/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.ArrayList;
import java.util.Set;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;

import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/**
 * ω}IplłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class VariationSelectorPanel implements	Adaptable, WidgetContainer {
    
	/** uω}v */
	static private final MessageResource LB_VARIATION 
			= new MessageResource(VariationSelectorPanel.class, "lbVariation"); //$NON-NLS-1$

	/** u{v */
	static private final MessageResource LB_REGULAR_PATH 
			= new MessageResource(VariationSelectorPanel.class, "lbRegularPath"); //$NON-NLS-1$

	/** uω}v */
	static private final MessageResource LB_ANOTHER_PATH 
			= new MessageResource(VariationSelectorPanel.class, "lbAnotherPath"); //$NON-NLS-1$

	
	
	private EventBroker eventBroker_;
	private Group selector_;

	/** 
	 * ω}I郉WI{^̃XgłB
	 * ω}ꍇω}葽vfɂĂ
	 * {@link MoveButton#setVisible(boolean)}falseɐݒ肳Ă܂B
	 */
	private final ArrayList<MoveButton> variationButtons_;
		
	private CoordinatesLabelProvider coordinatesLabelProvider_;
	
	private VariationLabelProvider variationLabelProvider_;
	
	private final Adapter adapter_;
	
	
	/**
	 * ݂NodeView̕ω}ێ܂B 
	 */
	private NodeView[] variations_;

	/**
     * 
     */
    public VariationSelectorPanel() {
        super();
        eventBroker_ = EventBroker.NULL_BROKER;
		variationButtons_ = new ArrayList<MoveButton>();
		coordinatesLabelProvider_ 
				= Yukinoshita.context().getProvider(
						CoordinatesLabelProvider.class, null);
		variationLabelProvider_ = VariationLabelProvider.CONTEXT.defaultProvider();
		adapter_ = new Adapter();
		variations_ = new NodeView[0];
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createControl(Composite)
     */
    public Control createContents(Composite parent) {
		selector_ = new Group(parent, SWT.SHADOW_ETCHED_IN);
		selector_.setLayout(new RowLayout(SWT.VERTICAL));
		selector_.setText(LB_VARIATION.get());
		MouseOnGroupListener listener = new MouseOnGroupListener();
		selector_.addListener(SWT.MouseWheel, listener);
		selector_.addMouseTrackListener(listener);
		return selector_;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        // ł͌㏈͕sv
    }

    
    /**
     * ω}(newVariation)ɏ]{@link MoveButton}ǉ܂B
     * 
     * @param newVariations
     */
    private void updateButtonArray(int newVariations) {
		int current = variationButtons_.size();
		for (int i = current; i < newVariations; ++i) {
		    MoveButton variation = new MoveButton(this, i);
		    variation.createControl(selector_, SWT.RADIO | SWT.FLAT);
			variationButtons_.add(variation);
		}
		for (int i = newVariations; i < variationButtons_.size(); ++i) {
			variationButtons_.get(i).setVisible(false);
		}
    }
    
    /**
     * {^̃xIԂXV܂B
     * 
     * @param index
     * @param sibling
     * @param isSelected
     */
    private void setupMoveButton(int index,  NodeView sibling, boolean isSelected) {
        MoveButton button = variationButtons_.get(index);
	    button.setSelection(isSelected);
	    String prefix = makeMoveButtonPrefix();
	    String postfix = makeMoveButtonPostfix(index, sibling);
		ImageResource imageResource = makeMoveButtonImageResource(sibling);
		button.set(prefix, imageResource, postfix);
		button.setVisible(true);
    }

    private String makeMoveButtonPrefix() {
	    String prefix = Strings.EMPTY;
        return prefix;
    }
    
    private String makeMoveButtonPostfix(int index, NodeView sibling) {
        StringBuilder ret = new StringBuilder();
        String moveLabel = Strings.EMPTY;
        try {
    		Property property = sibling.getProperty(SgfId.BLACK);
    		if (property != null) {
                SgfPoint sgfPoint;
                sgfPoint = SgfPoint.parseMove(sibling.getSize(), property.getString());
                moveLabel =  coordinatesLabelProvider_.getMoveLabel(sgfPoint);
    		}
    		property = sibling.getProperty(SgfId.WHITE);
    		if (property != null) {
                SgfPoint sgfPoint;
                sgfPoint = SgfPoint.parseMove(sibling.getSize(), property.getString());
                moveLabel = coordinatesLabelProvider_.getMoveLabel(sgfPoint);
    		}
    		ret.append(moveLabel);
    		ret.append(' ');
    		ret.append((index == 0) ? LB_REGULAR_PATH.get() : LB_ANOTHER_PATH.get());
    		ret.append(variationLabelProvider_.getVariationLabel(index));

        } catch (TypeParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
		return ret.toString();
    }
    
    private ImageResource makeMoveButtonImageResource(NodeView sibling) {
		ImageResource imageResource = NodeImage.VNONE;
		Property property = sibling.getProperty(SgfId.BLACK);
		if (property != null) {
		    imageResource = NodeImage.BLACK;
		}
		property = sibling.getProperty(SgfId.WHITE);
		if (property != null) {
		    imageResource = NodeImage.WHITE;
		}
		return imageResource;
    }
	
    
	/**
     * buttonIꂽƂʒm܂B
     * @param button
     */
    void variationChanged(MoveButton button) {
		eventBroker_.executeCommand(new SelectVariation(button.getIndex()));
    }

    /**
     * }EXzC[̃CxgnhO܂B<br>
     * GroupɃ}EXƃtH[JXDAGroup̃WI{^؂ւ܂B
     */
    private class MouseOnGroupListener extends MouseTrackAdapter implements Listener {

		private int index_ = 0;
		/* (non-Javadoc)
		 * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
		 */
		public void handleEvent(Event event) {
			if (variations_.length == 0) {
				return;
			}
			if (0 < event.count) {
				--index_;
				if (index_ < 0) {
					index_ = 0;
					}
			} else if (event.count < 0) {
				++index_;
				if (variations_.length <= index_) {
					index_ = variations_.length - 1;
				}
			}
			eventBroker_.executeCommand(new SelectVariation(index_));
		}
		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.MouseTrackListener#mouseEnter(org.eclipse.swt.events.MouseEvent)
		 */
		@Override
		public void mouseEnter(MouseEvent e) {
        	if (selector_.getShell() == Display.getCurrent().getActiveShell()) {
        		selector_.forceFocus();
        	}
		}
    }
    /**
     * ̃NXAdaptableƂĕԂC^[tFCXSĎĂ܂B
     * 
     */
    private class Adapter 
    		implements  GameMonitor, ModelEventNotifier, NodeMonitor, ContextMonitor {

        private CurrentContext context_ = CurrentContext.nullContext;
       
        private int variationIndex_;

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
         */
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull(gameMediator);
            
            context_ = gameMediator.getContext();
        }
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventHandler(org.unitarou.yukinoshita.events.ModelEventHandler)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(VariationSelectorPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(VariationSelectorPanel.this);
        }

        /**
         * ڂm[hselectedNodeViewɕύXɂȂƂɌĂяo܂B
         * @see org.unitarou.yukinoshita.view.monitor.NodeMonitor#currentChanged(org.unitarou.yukinoshita.model.NodeView)
         */
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull(nodeView);

            variations_ = nodeView.getVariations();
            variationIndex_ = nodeView.getSelectedVariationIndex();
            update();
    		selector_.layout();
        }
        
        /**
         * {^̃xƏԂXV܂B
         */
        private void update() {
    		updateButtonArray(variations_.length);
    		for (int i = 0; i < variations_.length; ++i) {
    		    setupMoveButton(i, variations_[i], i == variationIndex_);
    		}
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ContextMonitor#attributeChanged(java.util.Set)
         */
        public void attributeChanged(Set<String> keySet) {
            ArgumentChecker.throwIfNull(keySet);
            
            boolean needsRefresh = false;
            
            if (keySet.contains(CoordinatesLabelProvider.class.getName())) {
            	CoordinatesLabelProvider newProvider 
            			= context_.getProvider(CoordinatesLabelProvider.class);
            	if (!newProvider.equals(coordinatesLabelProvider_)) {
                	coordinatesLabelProvider_ = newProvider;
                    needsRefresh = true;
            	}
            }

            if (needsRefresh) {
            	update();
            	selector_.layout();
            }
        }
    }
}
