/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.gm.NoteMemoPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/**
 * lĂƂɃm[hIpl̕ςɕ\plłB
 * uHvu~v}[NuȂv{^܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ProblemActionPanel implements SelectablePanel {
	static private final Log log_s_ = LogFactory.getLog(ProblemActionPanel.class);
	
    /** H}[NłB*/
    static private final ImageResource QUESTION 
    		= new ImageResource(ProblemActionPanel.class, "problem00.png"); //$NON-NLS-1$

    /** }[NłB*/
    static private final ImageResource CORRECT 
    		= new ImageResource(ProblemActionPanel.class, "problem01.png"); //$NON-NLS-1$

    /** }[NłB*/
    static private final ImageResource QUASI_CORRECT 
    		= new ImageResource(ProblemActionPanel.class, "problem02.png"); //$NON-NLS-1$

    /** ~}[NłB*/
    static private final ImageResource WRONG 
    		= new ImageResource(ProblemActionPanel.class, "problem03.png"); //$NON-NLS-1$ 
    
    
    // TODO 𓚎̃}[N
    
    /** u߂(&G)v*/
    static private final MessageResource CLB_GIVEUP 
    		= new MessageResource(ProblemActionPanel.class, "clbGiveup"); //$NON-NLS-1$

    /** u蒼(&R)v*/
    static private final MessageResource CLB_RETRY
    		= new MessageResource(ProblemActionPanel.class, "clbRetry"); //$NON-NLS-1$

    /** uO̖(&P)v*/
    static private final MessageResource CLB_PREVIOUS
    		= new MessageResource(ProblemActionPanel.class, "clbPrevious"); //$NON-NLS-1$

    /** u̖(&N)v*/
    static private final MessageResource CLB_NEXT
    		= new MessageResource(ProblemActionPanel.class, "clbNext"); //$NON-NLS-1$

	/**
	 * ݂CollectionEditorQƂŕێ܂B
	 */
	private Reference<CollectionEditor> refCe_ = new WeakReference<CollectionEditor>(null);

	private EventBroker eventBroker_;

    /**
	 * ̃pl̍ŏʂ{@link Control}łB
	 * {@link #createContents(Composite)}ꂽƂɕێ܂B
	 */
	private Control rootControl_;
	
	private final Adapter adapter_;
	
	private Label imageLabel_;
	
	private Button giveup_;
	
	private Button retry_;
	
	/**
	 * uO̖v{^
	 */
	private Button previous_;

	/**
	 * u̖v{^
	 */
	private Button next_;

	private final NoteMemoPanel noteMemoPanel_;


	/**
     * 
     */
    public ProblemActionPanel() {
        super();
        eventBroker_ = EventBroker.NULL_BROKER;
        rootControl_ = null;
        adapter_ = new Adapter();
        imageLabel_ = null;
        giveup_ = null;
        retry_ = null;
        previous_ = null;
        next_ = null;
        noteMemoPanel_ = new NoteMemoPanel(false);
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
    	USashForm root = WidgetFactory.createUSashForm(parent, SWT.VERTICAL);
    	
        Composite control = new Composite(root, SWT.NONE);
		control.setLayout(new FillLayout(SWT.VERTICAL));

		imageLabel_ = new Label(control, SWT.SINGLE | SWT.BORDER);
		imageLabel_.setImage(QUESTION.get());
		
		Composite buttonPlane = new Composite(control, SWT.BORDER);
		buttonPlane.setLayout(new RowLayout(SWT.VERTICAL));
		
		giveup_ = new Button(buttonPlane, SWT.PUSH);
		giveup_.setText(CLB_GIVEUP.get());
		giveup_.addSelectionListener(new SelectionAdapter() {
			@Override
            public void widgetSelected(SelectionEvent e) {
				eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.ANSWER));
            }
		});

		retry_ = new Button(buttonPlane, SWT.PUSH);
		retry_.setText(CLB_RETRY.get());
		retry_.addSelectionListener(new SelectionAdapter() {
			@Override
            public void widgetSelected(SelectionEvent e) {
				eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
            }
		});
		
		previous_ = new Button(buttonPlane, SWT.PUSH);
		previous_.setText(CLB_PREVIOUS.get());
		previous_.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				CollectionEditor ce = refCe_.get();
				int index = ce.getActiveGameIndex();
				if (index == 0) {
					log_s_.warn("(BUG)Can't go to previous problem because of zero index, ignore it."); //$NON-NLS-1$
				} else {
					ce.getActiveGame().finishSolvingProblem();
					eventBroker_.executeCommand(new GameChangeCommand(--index));
					eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
				}
			}
		
		});
		

		next_ = new Button(buttonPlane, SWT.PUSH);
		next_.setText(CLB_NEXT.get());
		next_.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				CollectionEditor ce = refCe_.get();
				int index = ce.getActiveGameIndex();
				if (ce.size() <= index + 1) {
					log_s_.warn("(BUG)Can't go to next problem because of max index:" + index); //$NON-NLS-1$
				} else {
					ce.getActiveGame().finishSolvingProblem();
					eventBroker_.executeCommand(new GameChangeCommand(++index));
					eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
				}
			}
		
		});
		noteMemoPanel_.createContents(root);
		root.setWeights(new int[] {2, 1});
		rootControl_ = root;
		return rootControl_;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
    	noteMemoPanel_.dispose();
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /**
     * ̃EBWbg̃gbṽRg[Ԃ܂B
     * {@link #createContents(Composite)}OɌĂяoꂽꍇɂnullԂ܂B
     */
    public Control getControl() {
        return rootControl_;
    }
    
    private class Adapter 
    		implements ModelEventNotifier, CollectionMonitor, GameMonitor, 
    					ControllerStatusMonitor, ProblemStatusMonitor 
    {
    	
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            
            eventBroker_.removeView(ProblemActionPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(ProblemActionPanel.this);
            eventBroker_.addView(noteMemoPanel_);
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
		 */
		public void update(CollectionEditor collectionEditor) {
			refCe_ = new WeakReference<CollectionEditor>(collectionEditor); 
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			CollectionEditor ce = refCe_.get();
			if (ce == null) {
				next_.setEnabled(false);
			}
			
			//ŏIȊOŎ̖{^EnableɂB
			next_.setEnabled(ce.getActiveGameIndex() != (ce.size() - 1));
			
			//W̃CfbNXPȏ(h̏ꍇ2ȏ)őO̖{^EnableɂB
			int index = ce.getActiveGameIndex();
			previous_.setEnabled((!ce.isDrill() && 1 <= index) || 2 <= index);
		}

		/* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            // Ȃ
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase phase) {
            ArgumentChecker.throwIfNull(phase);
            
            if (phase.equals(HandlerPhase.SOLVE)) {
                updateStatusImpl(QUESTION, true, false);
            } else if (phase.equals(HandlerPhase.ANSWER)) {
                updateStatusImpl(QUESTION, false, true);
                //TODO 𓚎̋L
            }
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ProblemStatusMonitor#update(org.unitarou.yukinoshita.model.ProblemStatus)
         */
        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull(problemStatus);
            
            if (problemStatus.equals(ProblemStatus.SOLVE)) {
                updateStatusImpl(QUESTION, true, false);

            } else if (problemStatus.equals(ProblemStatus.CORRECT)) {
                updateStatusImpl(CORRECT, false, true);

            } else if (problemStatus.equals(ProblemStatus.QUASI_CORRECT)) {
                updateStatusImpl(QUASI_CORRECT, false, true);
                
            } else if (problemStatus.equals(ProblemStatus.WRONG)) {
                updateStatusImpl(WRONG, false, true);
            }
        }
        
        private void updateStatusImpl(
                ImageResource imageResource, boolean giveupEnabled, boolean retryEnabled) 
        {
            imageLabel_.setImage(imageResource.get());
            giveup_.setEnabled(giveupEnabled);
            retry_.setEnabled(retryEnabled);
        }
    }
}
