/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.pref;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/**
 * Ղ\ۂ̐ݒy[WłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class BoardPreferencePage extends FieldEditorPreferencePage {

	/** uՂ̕\v */
	static private final MessageResource NT_TITLE
			= new MessageResource(BoardPreferencePage.class, "ntTitle"); //$NON-NLS-1$
	
	
	/**
	 * ̃NXp̃vt@Xy[W쐬ĕԂ܂B
	 * @return
	 */
	static public PreferenceNode createPreferenceNode() {
		String className = BoardPreferencePage.class.getName();
		return new PreferenceNode(className, NT_TITLE.get(), null, className);
	}
	
	
	/**
	 * 
	 */
	public BoardPreferencePage() {
		super(FLAT);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	@Override
	protected void createFieldEditors() {
		Composite parent = getFieldEditorParent();
		addField(new BooleanFieldEditor(
					Context.DEFAULT_EDIT_MODE.id(), 
					Context.DEFAULT_EDIT_MODE.displayName(), parent));
		
		addField(new BooleanFieldEditor(
					Context.SHOW_LAST_MOVE_MARK.id(), 
					Context.SHOW_LAST_MOVE_MARK.displayName(), parent));
		
		IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(
				Context.MAX_STONE_SIZE.id(),
				Context.MAX_STONE_SIZE.displayName(),
				parent
				);
		integerFieldEditor.setEmptyStringAllowed(false);
		integerFieldEditor.setValidRange(1, 200);
		integerFieldEditor.setErrorMessage(Context.MAX_STONE_SIZE.errorMessage());
		addField(integerFieldEditor);
		
		addField(new RadioGroupFieldEditor(
				CoordinatesLabelProvider.CONTEXT.id(),
				CoordinatesLabelProvider.CONTEXT.displayName(),
				2,
				composeProviderSelector(CoordinatesLabelProvider.class),
				parent, true));

		addField(new RadioGroupFieldEditor(
				VariationLabelProvider.CONTEXT.id(),
				VariationLabelProvider.CONTEXT.displayName(),
				2,
				composeProviderSelector(VariationLabelProvider.class),
				parent, true));
		
		addField(new RadioGroupFieldEditor(
				StonePainter.CONTEXT.id(),
				StonePainter.CONTEXT.displayName(),
				2,
				composeProviderSelector(StonePainter.class),
				parent, true));
		
		addField(new RadioGroupFieldEditor(
				BlockLabelProvider.CONTEXT.id(),
				BlockLabelProvider.CONTEXT.displayName(),
				2,
				composeProviderSelector(BlockLabelProvider.class),
				parent, true));
	}
	

	private <T extends Provider> String[][] composeProviderSelector(Class<T> clazz) {
		T[] providers = Yukinoshita.context().getProviders(clazz);
		String[][] items = new String[providers.length][];
		for (int i = 0; i < providers.length; ++i) {
			items[i] = new String[]{providers[i].displayName(), providers[i].getClass().getName()};
		}
		return items;
	}
}