/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.pref;

import java.util.EnumSet;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;

import org.unitarou.ml.MessageResource;
import org.unitarou.yukinoshita.context.Context;

/**
 * t@C֘A̐ݒsy[WłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FilePreferencePage extends FieldEditorPreferencePage {

	/** ut@Cv */
	static private final MessageResource NT_TITLE
			= new MessageResource(FilePreferencePage.class, "ntTitle"); //$NON-NLS-1$
	
	/**
	 * ̃NXp̃vt@Xy[W쐬ĕԂ܂B
	 * @return
	 */
	static public PreferenceNode createPreferenceNode() {
		String className = FilePreferencePage.class.getName();
		return new PreferenceNode(className, NT_TITLE.get(), null, className);
	}
	
	/**
	 * 
	 */
	public FilePreferencePage() {
		super(FLAT);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	@Override
	protected void createFieldEditors() {
		Composite parent = getFieldEditorParent();
		
		addField(new RadioGroupFieldEditor(
				Context.FILE_DIALOG_STYLE.id(),
				Context.FILE_DIALOG_STYLE.displayName(),
				2,
				composeEnumSelector(Context.FileDialogStyle.class),
				parent, true));		
		
	}
	
	private <E extends Enum<E>> String[][] composeEnumSelector(Class<E> clazz) {
		EnumSet<E> enumSet = EnumSet.allOf(clazz);
		
		String[][] items = new String[enumSet.size()][];
		int index = 0;
		for (E item : enumSet) {
			items[index] = new String[]{item.toString(), item.name()};
			++index;
		}
		return items;
	}
}
