/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.resource;


import org.eclipse.swt.graphics.Point;

import org.unitarou.jface.CursorResource;
import org.unitarou.yukinoshita.view.jface.util.ColorCursorResource;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class CanvasCursor {
    
    /** W̃J[\łB */
    static public final CursorResource NORMAL 
    		= new CursorResource(CanvasCursor.class, "curNormal.png", new Point(2, 4)); //$NON-NLS-1$

    //--------------- Move[hpJ[\ ----------------------------------
    /** Ƃč΂̒ǉJ[\łB */
    static public final CursorResource MOVE_BLACK 
    		= new CursorResource(CanvasCursor.class, "curBlackMove.png", new Point(2, 4)); //$NON-NLS-1$

    /** ƂĔ΂̒ǉJ[\łB */
    static public final CursorResource MOVE_WHITE 
    		= new CursorResource(CanvasCursor.class, "curWhiteMove.png", new Point(2, 4)); //$NON-NLS-1$

    /** ܂͍΂̒ǉJ[\łB */
    static public final CursorResource MOVE_WB
    		= new CursorResource(CanvasCursor.class, "curWBMove.png", new Point(2, 4)); //$NON-NLS-1$

    /**u΂̒ǉv[h̃J[\łB*/
    static public final ColorCursorResource MOVE 
    		= new ColorCursorResource(MOVE_WHITE, MOVE_BLACK, MOVE_WB);
    

    /** ΂̃pXǉJ[\łB */
    static public final CursorResource PASS_BLACK 
    		= new CursorResource(CanvasCursor.class, "curBlackPass.png", new Point(2, 4)); //$NON-NLS-1$

    /** ΂̃pXǉJ[\łB */
    static public final CursorResource PASS_WHITE 
    		= new CursorResource(CanvasCursor.class, "curWhitePass.png", new Point(2, 4)); //$NON-NLS-1$
    

    /**upX̒ǉv[h̃J[\łB*/
    static public final ColorCursorResource PASS
    		= new ColorCursorResource(PASS_WHITE, PASS_BLACK, NORMAL);

    
    //--------------- Variation[hpJ[\ ----------------------------------
    /** ΂̕ω}ǉJ[\łB */
    static public final CursorResource VARIATION_BLACK 
    		= new CursorResource(CanvasCursor.class, "curBlackVariation.png", new Point(2, 4)); //$NON-NLS-1$

    /** ΂̕ω}ǉJ[\łB */
    static public final CursorResource VARIATION_WHITE
    		= new CursorResource(CanvasCursor.class, "curWhiteVariation.png", new Point(2, 4)); //$NON-NLS-1$

    /** ܂͍΂̕ω}ǉJ[\łB */
    static public final CursorResource VARIATION_WB
    		= new CursorResource(CanvasCursor.class, "curWBVariation.png", new Point(2, 4)); //$NON-NLS-1$

    /**uω}ǉv[h̃J[\łB*/
    static public final ColorCursorResource VARIATION 
    		= new ColorCursorResource(VARIATION_WHITE, VARIATION_BLACK, VARIATION_WB);
    
    
    //--------------- Setup[hpJ[\ ----------------------------------
    /** ΂̔zuJ[\łB */
    static public final CursorResource SET_BLACK 
    		= new CursorResource(CanvasCursor.class, "curBlackSet.png", new Point(2, 4)); //$NON-NLS-1$

    /** ΂̔zuJ[\łB */
    static public final CursorResource SET_WHITE 
    		= new CursorResource(CanvasCursor.class, "curWhiteSet.png", new Point(2, 4)); //$NON-NLS-1$

    /** zuō΂͂J[\łB */
    static public final CursorResource SET_BLACK_ERASE 
    		= new CursorResource(CanvasCursor.class, "curBlackErase.png", new Point(2, 4)); //$NON-NLS-1$

    /** zuŔ΂͂J[\łB */
    static public final CursorResource SET_WHITE_ERASE 
    		= new CursorResource(CanvasCursor.class, "curWhiteErase.png", new Point(2, 4)); //$NON-NLS-1$

    /**u΂͂v[h̃J[\łB*/
    static public final ColorCursorResource ERASE
    		= new ColorCursorResource(SET_WHITE_ERASE, SET_BLACK_ERASE, NORMAL);


    
    //--------------- Markup[hpJ[\ ----------------------------------
    /** MAvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_CROSS 
    		= new CursorResource(CanvasCursor.class, "curMarkCross.png", new Point(2, 4)); //$NON-NLS-1$

    /** CRvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_CIRCLE 
    		= new CursorResource(CanvasCursor.class, "curMarkCircle.png", new Point(2, 4)); //$NON-NLS-1$

    /** SQvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_SQUARE 
    		= new CursorResource(CanvasCursor.class, "curMarkSquare.png", new Point(2, 4)); //$NON-NLS-1$
    
    /** TRvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_TRIANGLE 
    		= new CursorResource(CanvasCursor.class, "curMarkTriangle.png", new Point(2, 4));     //$NON-NLS-1$
    
    /** SEvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_SELECT 
    		= new CursorResource(CanvasCursor.class, "curMarkSelect.png", new Point(2, 4)); //$NON-NLS-1$

    /** LBvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_LABEL 
    		= new CursorResource(CanvasCursor.class, "curMarkLabel.png", new Point(2, 4)); //$NON-NLS-1$
    
    /** TWvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_TERRITORY_WHITE
    		= new CursorResource(CanvasCursor.class, "curMarkTerritoryW.png", new Point(2, 4)); //$NON-NLS-1$
    
    /** TBvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_TERRITORY_BLACK
    		= new CursorResource(CanvasCursor.class, "curMarkTerritoryB.png", new Point(2, 4)); //$NON-NLS-1$

    /** DDvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_DIMMED
    		= new CursorResource(CanvasCursor.class, "curMarkDimmed.png", new Point(2, 4)); //$NON-NLS-1$

    /** DDvpeB̍폜J[\łB */
    static public final CursorResource MARK_DIMMED_ERASE
    		= new CursorResource(CanvasCursor.class, "curMarkDimmedErase.png", new Point(2, 4)); //$NON-NLS-1$

    //--------------- Line[hpJ[\ ----------------------------------
    /** LNvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_LINE
    		= new CursorResource(CanvasCursor.class, "curMarkLine.png", new Point(2, 4)); //$NON-NLS-1$

    /** ARvpeB̒ǉJ[\łB */
    static public final CursorResource MARK_ARROW
    		= new CursorResource(CanvasCursor.class, "curMarkArrow.png", new Point(2, 4)); //$NON-NLS-1$

    /**
     * 
     */
    protected CanvasCursor() {
        super();
    }
}
