/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.util;

import org.eclipse.swt.graphics.Cursor;

import org.unitarou.jface.CursorResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.util.ArgumentChecker;

/**
 * ԁEԁAsŃJ[\قȂꍇ
 * \[XǗNXłB
 *   
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ColorCursorResource {
    private CursorResource white_;
    private CursorResource black_;
    private CursorResource null_;

    /**
     * @param white {@link #get(SgfColor)}{@link SgfColor#WHITE}w肵Ƃ̃J[\B
     * @param black {@link #get(SgfColor)}{@link SgfColor#BLACK}w肵Ƃ̃J[\B
     * @param none {@link #get(SgfColor)}<code>null</code>w肵Ƃ̃J[\B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public ColorCursorResource(
            CursorResource white, CursorResource black, CursorResource none) {
        super();
        ArgumentChecker.throwIfNull(white, black, none);
        white_ = white;
        black_ = black;
        null_ = none;
    }
    
    /**
     * colorw肷邱ƂŁAɂJ[\Ԃ܂B
     * ɂnull܂B
     */
    public Cursor get(SgfColor color) {
        if (SgfColor.WHITE.equals(color)) {
            return white_.getCursor();
            
        } else if (SgfColor.BLACK.equals(color)) {
            return black_.getCursor();
        }
        return null_.getCursor();
    }

}
