/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.lang.NamedEnum;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.lang.UEnum}
 * {@link org.eclipse.swt.widgets.Combo}
 * 쐬AێNXłB
 * 
 * lƃIWiɑΉ܂B̏ꍇ
 * {@link #getSelected()}nullԂA
 * {@link #getSelectedDatum()}͎ۂ̕Ԃ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class UEnumCombo<T extends UEnum> implements WidgetContainer {
    
    /** uv */
    static private final MessageResource LB_EMPTY 
    		= new MessageResource(UEnumCombo.class, "lbEmpty"); //$NON-NLS-1$

    private final Class<T> clazz_;
    private Combo combo_;
    /**
     * 
     * @param clazz {@link UEnum}pĂKv܂B
     */
    public UEnumCombo(Class<T> clazz) {
        super();
        ArgumentChecker.throwIfNull(clazz);
        if (!(UEnum.class.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException();
        }
        clazz_ = clazz;
    }

    /**
     * {@link org.eclipse.swt.widgets.Combo}CX^XԂƂۏ؂܂B
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        combo_ = new Combo(parent, SWT.READ_ONLY | SWT.DROP_DOWN);
        combo_.add(LB_EMPTY.get());
        UEnum[] enums = UEnum.getAll(clazz_);
        for (int i = 0; i < enums.length; ++i) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(enums[i].typeName());
            if (enums[i] instanceof NamedEnum) {
                buffer.append(':')
                	  .append(((NamedEnum)enums[i]).displayName());
            }
            combo_.add(buffer.toString());
        }
        if (combo_.getItemCount() != 0) {
            combo_.select(0);
        }
        return combo_;
    }
    
    /**
     * enumElementɊY鍀ڂI܂B
     * ͂w肳ꍇnullw肵܂B
     */
    public void select(UEnum enumElement) {
        if (enumElement == null) {
            combo_.select(0);
            return;
        }
        int index = 1;
        UEnum[] enums = UEnum.getAll(clazz_);
        for (int i = 0; i < enums.length; ++i) {
            if (enums[i].equals(enumElement)) {
                combo_.select(index);
                return;
            }
            ++index;
        }
        assert false : "Unknown enumElement :" + enumElement; //$NON-NLS-1$
    }
    
    /**
     * 
     */
    public void setText(String text) {
        combo_.setText(text);
    }
    
    public Combo getCombo() {
        return combo_;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        // ł͉Ȃ
    }

    /**
     * @param isEditMode
     */
    public void setEditable(boolean isEditMode) {
        combo_.setEnabled(isEditMode);
    }

    /**
     * IƃIWȉꍇnullԂ܂B
     * @return
     */
    public UEnum getSelected() {
        int index = combo_.getSelectionIndex();
        if (index <= 0) {
            return null;
        }
        --index;
        return UEnum.getAll(clazz_)[index];
    }
    
    /**
     * ̂܂ܕԂ܂B
     * IƃIWȉꍇ̕Ԃ܂B
     */
    public String getSelectedDatum() {
        int index = combo_.getSelectionIndex();
        if (index == 0) {
            return Strings.EMPTY;
        }
        if (index == -1) {
            return combo_.getText();
        }

        --index;
        UEnum[] enums = UEnum.getAll(clazz_);
        return enums[index].typeName().toString();
    }

    /**
     * @return
     */
    public boolean getEditable() {
        return combo_.getEnabled();
    }
}
