/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;

import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;

/**
 * EBWbg\zɐݒ荀ڂʉ邱ƂړIƂt@Ng[NXłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class WidgetFactory {
	

	/**
	 * {@link SashForm}ȉ̐ݒō\z܂B<br>
	 * <ol>
	 * <li>{@link SashForm#SASH_WIDTH}R</li>
	 * <li>SWT.SMOOTHݒ</li>
	 * </ol>
	 * @param parent
	 * @param style
	 * @return
	 */
	static public SashForm createSashForm(Composite parent, int style) {
		ArgumentChecker.throwIfNull(parent);
        SashForm ret = new SashForm(parent, style | SWT.SMOOTH);
        ret.SASH_WIDTH = 3;
        return ret;
	}
	
	/**
	 * {@link USashForm}ȉ̐ݒō\z܂B<br>
	 * <ol>
	 * <li>{@link SashForm#SASH_WIDTH}5</li>
	 * <li>SWT.SMOOTHݒ</li>
	 * </ol>
	 * @param parent
	 * @param style
	 * @return
	 */
	static public USashForm createUSashForm(Composite parent, int style) {
		ArgumentChecker.throwIfNull(parent);
		USashForm ret = new USashForm(parent, style | SWT.SMOOTH);
        ret.setSashWidth(5);
        return ret;
	}
	
	/**
	 * 
	 */
	protected WidgetFactory() {
		super();
	}

}
