/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.blklp;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.context.ProviderContextValue;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;

/**
 * Ղ̊eubNɕ\郉xp̃voC_[łB
 * ʂɂ͐΂ƂɒԍȂǂ\܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface BlockLabelProvider extends Provider, BlockPainter {
    
    /**
     * ReLXg̃L[ƃftHgvoC_[łB
     * ftHg̃voC_[{@link NoBlockLabelProvider}łB
     */
    ProviderContextValue<BlockLabelProvider> CONTEXT 
    		= new ProviderContextValue<BlockLabelProvider>(
    				BlockLabelProvider.class, 
    				new NoBlockLabelProvider());

    /**
     * ݂nodeView̏󋵂̂ƂŁApointɕ\郉xԂ܂B
     * \svȏꍇ͋󕶎{@link org.unitarou.lang.Strings#EMPTY}ԂA
     * null͕Ԃ܂B
     * 
     * @param nodeView
     * @param point
     * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    String getLabel(NodeView nodeView, SgfPoint point);
}
