/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.blklp;

import java.util.Set;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NoBlockLabelProvider implements BlockLabelProvider {
    /** u\Ȃv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(NoBlockLabelProvider.class, "lbDisplayName"); //$NON-NLS-1$

    /**
     * 
     */
    public NoBlockLabelProvider() {
        super();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.blp.BlockLabelProvider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.blp.BlockLabelProvider#getLabel(org.unitarou.yukinoshita.model.NodeView, org.unitarou.sgf.type.SgfPoint)
     */
    public String getLabel(NodeView nodeView, SgfPoint point) {
        return Strings.EMPTY;
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getDurablePaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getDurablePaintings(NodeView now) {
		return BlockPainter.EMPTY_SET;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getTransientPaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
		return BlockPainter.EMPTY_SET;
	}
}
