/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.blklp;

import java.util.Set;
import java.util.TreeSet;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;

/**
 * ΂̊_(_)\voC_[łB
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class StoneLifePointProvider implements BlockLabelProvider {
    /** u_v*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(StoneLifePointProvider.class, "lbDisplayName"); //$NON-NLS-1$

    /**
     * 
     */
    public StoneLifePointProvider() {
        super();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.blp.BlockLabelProvider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.blp.BlockLabelProvider#getLabel(org.unitarou.yukinoshita.model.NodeView, org.unitarou.sgf.type.SgfPoint)
     */
    public String getLabel(NodeView nodeView, SgfPoint point) {
        ArgumentChecker.throwIfNull(nodeView, point);
        Integer lifePoint = new Integer(nodeView.getIgoBoard().lifePoint(point));
        return (lifePoint == null) ? Strings.EMPTY : lifePoint.toString();
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getDurablePaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getDurablePaintings(NodeView now) {
		return BlockPainter.EMPTY_SET;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getTransientPaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
		ArgumentChecker.throwIfNull(nodeView);
		
		Set<SgfPoint> ret = new TreeSet<SgfPoint>();
		ret.addAll(nodeView.getIgoBoard().position(SgfColor.BLACK));
		ret.addAll(nodeView.getIgoBoard().position(SgfColor.WHITE));
		return ret;
	}
}
