/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.blklp;

import java.util.Set;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;

/**
 * lʎԂu:bvŕ\ubNxvoC_[łB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class TimeLapsedMsBlProvider implements BlockLabelProvider {
    /** uԍv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(TimeLapsedMsBlProvider.class, "lbDisplayName"); //$NON-NLS-1$

	/**
	 * 
	 */
	public TimeLapsedMsBlProvider() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider#getLabel(org.unitarou.yukinoshita.model.NodeView, org.unitarou.sgf.type.SgfPoint)
	 */
	public String getLabel(NodeView nodeView, SgfPoint point) {
        Stone stone = nodeView.getIgoBoard().getStone(point);
        if (stone == null) {
        	return Strings.EMPTY;
        }
        Double tl = stone.getTimeLapsed();
        if (tl != null) {
        	return Strings.formatDuration(tl.intValue());
        }
    	return Strings.EMPTY;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.Provider#getDisplayName()
	 */
	public String displayName() {
		return LB_DISPLAY_NAME.get();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getDurablePaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getDurablePaintings(NodeView now) {
		// TODO 蔲(΂̂ꏊɒuׂAvZRXĝ)
		return BlockPainter.EMPTY_SET;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getTransientPaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
		return BlockPainter.EMPTY_SET;
	}
}
