/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.clp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;

/**
 * t@ČɂȂ悤ȃx쐬voC_[łB<br>
 * ̓Iɂ{@link org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider}
 * {@link Collection}̑SĂ{@link org.unitarou.sgf.RootGameTree}ɑ΂ĒA
 * ŏɋ󕶎ȊOԂʁ{u[m ll]vƕ\܂B<br>
 * Sċ󕶎̏ꍇ́u[m ll]vłB<br>
 * ȂƋl̂ǂ炩ȂꍇA܂mCl̒lꂼ
 * 0̏ꍇ͂̃x͕\܂B<br> 
 * ܂mCl̂ǂ炩ꌏ݂̂̏ꍇ͕͑\܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ForFileNameCollectionProvider implements CollectionLabelProvider {
	
	/** u{0}v*/
	static private MessageResource LB_RGT_GAME_COUNTER
			= new MessageResource(ForFileNameCollectionProvider.class, "lbRgtGameCounter"); //$NON-NLS-1$
	
	/** ul{0}v*/
	static private MessageResource LB_RGT_PROBLEM_COUNTER
	= new MessageResource(ForFileNameCollectionProvider.class, "lbRgtProblemCounter"); //$NON-NLS-1$

	/**
	 * 
	 */
	public ForFileNameCollectionProvider() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.clp.CollectionLabelProvider#getLabel(org.unitarou.sgf.Collection)
	 */
	public String getLabel(Collection collection) {
		ArgumentChecker.throwIfNull(collection);
		StringBuilder builder = new StringBuilder();
		
		int games = 0;
		int problems = 0;
		GreedyRgtLabelProvider provider = new GreedyRgtLabelProvider();
		for (RootGameTree rgt : collection) {
			if (builder.length() == 0) {
				builder.append(provider.getLabel(rgt));
			}
			switch (rgt.getGameType()) {
			case GAME:
				++games;
				break;
				
			case PROBLEM:
				++problems;
				break;
				
			default:
				break;
			}
		}
		
		// ǂ炩P݂̂ꍇprovier̃x݂̂ԂB
		if (games + problems <= 1) { 
			return builder.toString();
		}
		
		if (games != 0) {
			builder.append('[')
			       .append(LB_RGT_GAME_COUNTER.get(new Integer(games)));
		}
		if (problems != 0) {
			builder.append((games != 0) ? ',' : '[')
				   .append(LB_RGT_PROBLEM_COUNTER.get(new Integer(problems)))
				   .append(']');
		}
		return builder.toString();
	}

}
