/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.nlp;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class BasicLabel implements NodeViewLabel {
	static private final BasicPropertyLabelProvider provider_s_ = new BasicPropertyLabelProvider();
	private final SgfId sgfId_;
	
	/**
	 * 
	 */
	public BasicLabel(SgfId sgfId) {
		super();
		ArgumentChecker.throwIfNull(sgfId);
		sgfId_ = sgfId;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabel#getLabel(org.unitarou.sgf.type.GameType, org.unitarou.yukinoshita.model.NodeView)
	 */
	public String getLabel(GameType gameType, NodeView nodeView) {
		ArgumentChecker.throwIfNull(gameType, nodeView);
		Property property = nodeView.getProperty(sgfId_);
		if (property == null) {
			return Strings.EMPTY;
		}
		return provider_s_.getLabel(gameType, property);
	}
}
