/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.nlp;

import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.context.ProviderContextValue;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * {@link org.unitarou.yukinoshita.model.NodeView}̓es̃eLXg
 * \郉xvoC_[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface NodeViewLabelProvider extends Provider {
	
    /**
     * ReLXg̃L[ƃftHgvoC_[łB
     * ftHg̃voC_[{@link Ver1NodeLabelProvider}łB
     */
    ProviderContextValue<NodeViewLabelProvider> CONTEXT 
    		= new ProviderContextValue<NodeViewLabelProvider>(
    				NodeViewLabelProvider.class, 
    				new Ver1NodeLabelProvider());
	
	/**
     * nodeView烉x([UɌ
     * {@link org.unitarou.sgf.Node}̈s)Ԃ܂B
     * 񂪉ԂȂꍇ{@link org.unitarou.lang.Strings#EMPTY}ԂA
     * <code>null</code>͕ԂȂłB
	 * 
	 * @param nodeView
	 * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	String getLabel(NodeView nodeView);
}
