/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.nlp;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class PropertyTypeLabel implements NodeViewLabel {

	private final PropertyType propertyType_;

	/**
	 *  
	 */
	private final String label_;

	/**
	 * 
	 */
	public PropertyTypeLabel(PropertyType propertyType) {
		this(propertyType, false);
	}

	/**
	 * 
	 */
	public PropertyTypeLabel(PropertyType propertyType, boolean overrideTypeName) {
		super();
		ArgumentChecker.throwIfNull(propertyType);
		
		propertyType_ = propertyType;
		if (overrideTypeName) {
			label_ 
				= new MessageResource(
						NodeViewLabel.class, 
						propertyType.name()).get();
		} else {
			label_ = propertyType.displayName();
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabel#getLabel(org.unitarou.yukinoshita.model.NodeView)
	 */
	public String getLabel(GameType gameType, NodeView nodeView) {
		ArgumentChecker.throwIfNull(gameType, nodeView);
		
        if (nodeView.containsPropertyType(propertyType_)) {
        	return label_;
        }
		return Strings.EMPTY;
	}

}
