/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.nlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class Ver1NodeLabelProvider implements NodeViewLabelProvider {

	static private final NodeViewLabel[] nodeViewLabels_s_
		= new NodeViewLabel[] {
			new PropertyTypeLabel(PropertyType.ROOT),
			new PropertyTypeLabel(PropertyType.GAME_INFO),
			new PropertyTypeLabel(PropertyType.SETUP),
			new BasicLabel(SgfId.PLAYER_TO_PLAY),
			new BasicLabel(SgfId.NODENAME),
			new BasicLabel(SgfId.COMMENT),
			new BasicLabel(SgfId.DOUBTFUL),
			new BasicLabel(SgfId.INTERESTING),
			new BasicLabel(SgfId.TESUJI),
			new BasicLabel(SgfId.BAD_MOVE),
			new BasicLabel(SgfId.GOOD_FOR_WHITE),
			new BasicLabel(SgfId.GOOD_FOR_BLACK),
			new BasicLabel(SgfId.EVEN_POSITION),
			new BasicLabel(SgfId.UNCLEAR_POS),
			new BasicLabel(SgfId.HOTSPOT),
	};
	
	/** uWv*/
	static private final MessageResource LB_DISPLAY_NAME
		= new MessageResource(Ver1NodeLabelProvider.class, "lbDisplayName"); //$NON-NLS-1$
	/**
	 * 
	 */
	public Ver1NodeLabelProvider() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider#getLabel(org.unitarou.yukinoshita.model.NodeView)
	 */
	public String getLabel(NodeView nodeView) {
		ArgumentChecker.throwIfNull(nodeView);
		GameType gameType = nodeView.getRootView().getGameType();
		StringBuilder sb = new StringBuilder();
        for (NodeViewLabel nodeViewLabel :  nodeViewLabels_s_) {
        	String label = nodeViewLabel.getLabel(gameType, nodeView);
        	if (label.length() != 0) {
        		label += ' ';
        	}
        	sb.append(label);
        }
        return sb.toString(); 
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.Provider#getDisplayName()
	 */
	public String displayName() {
		return LB_DISPLAY_NAME.get();
	}
}
