/*
 * Copyright 2005 unitarou <boss@unitarou.org>.
 * All rights reserved.
 *
 * This program and the accompanying materials are made available under the terms of
 * the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://opensource.org/licenses/cpl.php
 *
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;

/**
 * W{@link org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider}łB
 * g΋ǖh<br>
 * (Ȃ)g햼[Eh]h<br>
 * (Ȃ)g[i] vs. [i]h<br>
 * (Ȃ) 󕶎\܂B<br>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class DefaultRgtLabelProvider implements RootGameTreeLabelProvider {

	/** uWv */
	static private final MessageResource LB_DISPLAY_NAME 
			= new MessageResource(DefaultRgtLabelProvider.class, "lbDisplayName"); //$NON-NLS-1$

	/** uvs.v */
	static private final MessageResource LB_VERSUS 
			= new MessageResource(DefaultRgtLabelProvider.class, "lbVersus"); //$NON-NLS-1$

	/** u(s)v */
	static private final MessageResource LB_UNKNOWN 
			= new MessageResource(DefaultRgtLabelProvider.class, "lbUnknown"); //$NON-NLS-1$

	/**
	 * 
	 */
	public DefaultRgtLabelProvider() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider#getLabel(org.unitarou.sgf.RootGameTree)
	 */
	public String getLabel(RootGameTree rootGameTree) {
		ArgumentChecker.throwIfNull(rootGameTree);

		Sequence sequence = rootGameTree.getSequence();
		String datum;
		datum = composeGameName(sequence);
		if (!datum.equals(Strings.EMPTY)) {
			return datum;
		}

		datum = composeEventInfo(sequence);
		if (!datum.equals(Strings.EMPTY)) {
			return datum;
		}

		return composePlayerInfo(sequence);
	}

	/**
	 * sequence擪猟āAGNm[hꍇ͂̒lԂ܂B Ȃꍇ{@link Strings#EMPTY}Ԃ܂B
	 * 
	 * @param sequence
	 * @return
	 */
	private String composeGameName(Sequence sequence) {
		return BasicFinder.findDatum(sequence, SgfId.GAME_NAME);
	}

	/**
	 * sequence擪猟āAEVm[hꍇ͂̒lԂ܂B ɂ̃m[hROꍇ͊[]łČɒǉ܂B EVȂꍇ{@link Strings#EMPTY}Ԃ܂B
	 * 
	 * @param sequence
	 * @return
	 */
	private String composeEventInfo(Sequence sequence) {
		Node node = BasicFinder.findNode(sequence, SgfId.EVENT);
		if (node != null) {
			return compose(node, SgfId.EVENT, SgfId.ROUND);
		}
		return Strings.EMPTY;
	}

	/**
	 * sequence擪猟āAPWm[hꍇ͂̒lԂ܂B ɂ̃m[hWRꍇ͊[]łČɒǉ܂B
	 * ܂PBABRꍇl̏܂B PWȂꍇ{@link Strings#EMPTY}Ԃ܂B
	 * 
	 * @param sequence
	 * @return
	 */
	private String composePlayerInfo(Sequence sequence) {
		Node node = BasicFinder.findNode(sequence, SgfId.PLAYER_WHITE);
		node = (node != null) ? node : BasicFinder.findNode(sequence, SgfId.PLAYER_BLACK);
		if (node == null) {
			return Strings.EMPTY;
		}
		StringBuilder stringBuffer = new StringBuilder();
		String white = compose(node, SgfId.PLAYER_WHITE, SgfId.WHITE_RANK);
		stringBuffer.append(Strings.EMPTY.equals(white) ? LB_UNKNOWN.get() : white);
		stringBuffer.append(' ').append(LB_VERSUS.get()).append(' ');

		String black = compose(node, SgfId.PLAYER_BLACK, SgfId.BLACK_RANK);
		stringBuffer.append(Strings.EMPTY.equals(black) ? LB_UNKNOWN.get() : black);
		return stringBuffer.toString();
	}

	/**
	 * sequence̒mainType{@link Node}A gmainType[subType]h`̕\ĕԂ܂B
	 * mainTypẽvpeB݂Ȃꍇ{@link Strings#EMPTY}Ԃ܂B subTypẽvpeB݂Ȃꍇ́gmainĥ݂Ԃ܂B
	 */
	private String compose(Node node, SgfId mainType, SgfId subType) {
		String main = BasicFinder.findDatum(node, mainType);
		if (node == null) {
			return Strings.EMPTY;
		}
		String sub = BasicFinder.findDatum(node, subType);
		return (sub.equals(Strings.EMPTY)) ? main : main + " [" + sub + "]"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
		return LB_DISPLAY_NAME.get();
	}

}
