/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.provider.vlp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;

/**
 * LmV^Ver.1.xn̕ω}xƓ̕\sxvoC_[łB
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Ver1VariationLabelProvier implements VariationLabelProvider {
    /**uWv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(Ver1VariationLabelProvier.class, "lbDisplayName"); //$NON-NLS-1$

    static private final Messages msg_s_ 
    		= Messages.createByPackage(Ver1VariationLabelProvier.class);
    
    /**
     * J}؂Ńx̒l̂̂L[Ă܂B
     * FVariations=,`,a,b,c,d,e,f,g,h
     */
    static private final String VARIATIONS 
    		= Messages.createKey(Ver1VariationLabelProvier.class, "Variations"); //$NON-NLS-1$
        	
    static private final String[] variationLabels_s_;
    static  {
        List<String> labels = new ArrayList<String>(27); // At@xbg啶26+{
        String src = msg_s_.get(VARIATIONS);
        StringTokenizer st = new StringTokenizer(src, String.valueOf(','));
        while (st.hasMoreTokens()) {
            labels.add(st.nextToken());
        }
        variationLabels_s_ = labels.toArray(new String[labels.size()]);
    }
    
    /**
     * 
     */
    public Ver1VariationLabelProvier() {
        super();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.vlp.VariationLabelProvider#getVariationLabel(int)
     */
    public String getVariationLabel(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is out of bounds: " + index); //$NON-NLS-1$
        }
        if (variationLabels_s_.length <= index) {
            return Strings.EMPTY;
        }
        return variationLabels_s_[index];
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.provider.Provider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

}
