// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE1 $
// $Id: imkit_anthy_qpe16.cpp,v 1.4 2003/01/19 08:20:56 yamaken Exp $

#include <qwidget.h>
#include <qhbox.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qtopia/inputmethodinterface.h>
#include "keyfilter.h"
#include "engine_anthy.h"
#include "ui_anthy.h"
//#include "imkit_qlineedit.h"
#include "imwidget.h"
#include "imwidget_std.h"
#include "platform_qpe16.h"
#include "imkit_anthy_qpe16.h"


static IMUserInterface *
  create_custom_anthy_ui(StdIMWidgetFactory *elem_factory);
static QPixmap *create_icon(void);
static ExtInputMethodInterface *create_instance(void);

static const char *anthy_icon_xpm[];


//TODO: Anthy򤵤Ƥǧ䤹Τѹ
static const char *anthy_icon_xpm[] = {
"28 14 2 1",
"# c #000000",
". c None",
".........##..##.##..........",
"..........##.##.##..........",
"..........###########.......",
".......##....##.##..........",
"........##..########........",
"........##..##.##.##........",
"............########........",
".........##....##...........",
".........##.########........",
".........##....##...........",
"........##.##########.......",
"........##....##.#..........",
".......##....##..##.........",
".......##..###....###......."
};


Qpe16AnthyGUI::Qpe16AnthyGUI(AnthyEngine *engine_init,
                             StdIMWidgetFactory *imwidget_factory_init)
  : AnthyGUI(engine_init, imwidget_factory_init)
{
}

void
Qpe16AnthyGUI::connect_signals(void) {
  AnthyGUI::connect_signals();
  connect(_engine, SIGNAL(committed(const QString &)),
          preedit, SLOT(commit(const QString &)));
}

static IMUserInterface *
create_custom_anthy_ui(StdIMWidgetFactory *elem_factory) {
  AnthyEngine *engine;
  IMUserInterface *anthy_ui;

  engine = new AnthyEngine;
  anthy_ui = new Qpe16AnthyGUI(engine, elem_factory);

  return anthy_ui;
}

static QPixmap *
create_icon(void) {
  QPixmap *icon;

  icon = new QPixmap((const char **)anthy_icon_xpm);

  return icon;
}

static ExtInputMethodInterface *
create_instance(void) {
  IMUserInterface *ui;
  Qpe16IMElemFactory *elem_factory;
  ExtInputMethodInterface *instance;

  elem_factory = new Qpe16IMElemFactory;
  ui = create_custom_anthy_ui(elem_factory);
  //Q_CREATE_INSTANCE(IMKitImpl(ui, elem_factory, icon))
  instance = new ExtIMKitImpl(ui, elem_factory, create_icon());

  return instance;
}

IMKIT_EXPORT_EXTINTERFACE(create_instance);
