// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE1 $
// $Id: platform_qpe.cpp,v 1.7 2003/01/19 09:54:27 yamaken Exp $

#include <qfont.h>
#include <qtranslator.h>
#include <qapplication.h>
#include <qpe/qpeapplication.h>
#include <qpe/fontmanager.h>
#include "platform_qpe.h"

void
imkit_set_font(QWidget *widget) {
  QString lang;

  lang = getenv("LANG");
  if (lang != "ja" && FontManager::hasUnicodeFont()) {
    widget->setFont(FontManager::unicodeFont(FontManager::Proportional));
  }
}

void
imkit_setup_translator(QString &im_name) {
  QTranslator *trans;
  QString lang, trans_path, trans_file;

  lang = getenv("LANG");
  trans = new QTranslator(qApp);
  trans_file = "libimkit-" + im_name + ".qm";
  trans_path = QPEApplication::qpeDir() + "/i18n/" + lang + "/" + trans_file;
  if (trans->load(trans_path)) {
    qApp->installTranslator(trans);
  } else {
    delete trans;
  }
}

QUnknownInterface *
imkit_export_interface(InputMethodCreator creator) {
  InputMethodInterface *instance;
  QUnknownInterface *iface = 0;

  instance = (*creator)();
  instance->queryInterface(IID_QUnknown, &iface);

  return iface;
}

void
QWSKeyBypassIn::on_activate(void) {
  QWSServer::setKeyboardFilter(this);
}

void
QWSKeyBypassIn::on_deactivate(void) {
  QWSServer::setKeyboardFilter(NULL);
}

QWSKeyBypassIn::QWSKeyBypassIn(void) : QObject(NULL, "QWSKeyBypassIn") {
}

QWSKeyBypassIn::~QWSKeyBypassIn(void) {
}

bool
QWSKeyBypassIn::filter(int unicode, int keycode, int modifiers,
                       bool is_press, bool autorepeat)
{
  QKeyEvent *e;
  bool stopped;

  e = keyevent_converter.create(unicode, keycode, modifiers,
                                is_press, autorepeat);
  e->ignore();
  output(e);
  stopped = e->isAccepted();

  return stopped;
}

void
QWSKeyBypassIn::slot_activate(bool activity) {
  activate(activity);
}

void
QWSKeyBypassOut::on_input(QKeyEvent &e) {
  emit_as_signal(e);
}

void
QWSKeyBypassOut::emit_as_signal(QKeyEvent &e) {
  keyevent_converter.convert(&e);
}

void
QWSKeyBypassOut::emit_key(int unicode, int scancode,
                          int modifiers,
                          bool is_press, bool autorepeat)
{
  emit key(unicode, scancode, modifiers, is_press, autorepeat);
}

QWSKeyBypassOut::QWSKeyBypassOut(void) : QObject(NULL, "QWSKeyBypassOut") {
  connect(&keyevent_converter, SIGNAL(converted(int, int, int, bool, bool)),
          this, SLOT(emit_key(int, int, int, bool, bool)));
}

QWSKeyBypassOut::~QWSKeyBypassOut(void) {
}

void
QWSKeyBypassOut::input(QKeyEvent *e) {
  if (is_active()) {
    on_input(*e);
  }
  output(e);
}

void
IMKitImpl::prepare_key_bypass(void) {
  bypass_in = new QWSKeyBypassIn;
  bypass_out = new QWSKeyBypassOut;
  bypass_in->insert_after(bypass_out);
  bypass_out->activate();
}

void
IMKitImpl::join_to_bypass(CascadeKeyFilter *im_keyfilter) {
  if (!bypass_in) {
    prepare_key_bypass();
  }
  bypass_out->insert_before(im_keyfilter);
}

IMKitImpl::IMKitImpl(IMUserInterface *im_ui_init, QPixmap *icon_init = 0)
  : ref(0), im_ui(im_ui_init), _icon(icon_init),
    bypass_in(NULL), bypass_out(NULL)
{
  QString im_name;

  prepare_key_bypass();
  join_to_bypass(im_ui->keyfilter_begin());
  QObject::connect(im_ui, SIGNAL(slot_activated(bool)),
                   bypass_in, SLOT(slot_activate(bool)));
#ifdef IMKIT_MISSING_TRANSLATION_SETUP
  //CVSQtopiaˤϥɤޤޤƤ뤬widgetload
  //Τǵǽʤ
  im_name = im_ui->name().lower();
  imkit_setup_translator(im_name);
#endif
}

IMKitImpl::~IMKitImpl(void) {
  delete _icon;
  delete im_ui;
}

QWidget *
IMKitImpl::inputMethod(QWidget *parent, Qt::WFlags flags) {
  QWidget *imwidget;

  imwidget = im_ui->imwidget(parent, flags);
  imkit_set_font(imwidget);

  return imwidget;
}

void
IMKitImpl::resetState(void) {
  im_ui->reset_state();
}

QPixmap *
IMKitImpl::icon(void) {
  return _icon;
}

QString
IMKitImpl::name(void) {
  return im_ui->name();
}

void
IMKitImpl::onKeyPress(QObject *receiver, const char *slot) {
  QObject::connect(bypass_out, SIGNAL(key(ushort,ushort,ushort,bool,bool)),
                   receiver, slot);
}

QRESULT
IMKitImpl::queryInterface(const QUuid &uuid, QUnknownInterface **interface) {
  *interface = 0;

  if (uuid == IID_QUnknown || uuid == IID_InputMethod) {
    *interface = this;
  }
  
  if (*interface) {
    (*interface)->addRef();
  }

  return QS_OK;
}
