// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE9 $
// $Id: imkit_anthy_qpe.cpp,v 1.8 2003/11/03 20:49:31 yamaken Exp $

#include <qpixmap.h>
#include "imwidget.h"
#include "imwidget_std.h"
#include "ui.h"
#include "ui_std.h"
#include "platform_qpe.h"
#include "engine_anthy.h"
#include "ui_anthy.h"


static IMUserInterface *
  create_custom_anthy_ui(StdIMWidgetFactory *elem_factory);
static QPixmap *create_icon(void);

static const char *anthy_icon_xpm[];


//TODO: Anthy򤵤Ƥǧ䤹Τѹ
//TODO: ϥե뤫ɤ߹褦ˤ
static const char *anthy_icon_xpm[] = {
"28 14 2 1",
"# c #000000",
". c None",
".........##..##.##..........",
"..........##.##.##..........",
"..........###########.......",
".......##....##.##..........",
"........##..########........",
"........##..##.##.##........",
"............########........",
".........##....##...........",
".........##.########........",
".........##....##...........",
"........##.##########.......",
"........##....##.#..........",
".......##....##..##.........",
".......##..###....###......."
};

//TODO: ǤդUIǤ򥫥ޥؤǤ褦ˤ
//(IMWidgetFactoryѻߤȺ߷)

static IMUserInterface *
create_custom_anthy_ui(StdIMWidgetFactory *elem_factory) {
  AnthyEngine *engine;
  IMUserInterface *anthy_ui;

  engine = new AnthyEngine;
  anthy_ui = new AnthyGUI(engine, elem_factory);

  return anthy_ui;
}

static QPixmap *
create_icon(void) {
  QPixmap *icon;

  icon = new QPixmap((const char **)anthy_icon_xpm);

  return icon;
}

IMKIT_EXPORT_INTERFACE(create_custom_anthy_ui, create_icon());
