// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE9 $
// $Id: aux_keyhelper.cpp,v 1.2 2004/03/10 01:53:13 yamaken Exp $

#include <qevent.h>
#include <qcopchannel_qws.h>
#ifdef IMKIT_QPE16_PLATFORM
#include <qtopia/qcopenvelope_qws.h>
#else
#include <qpe/qcopenvelope_qws.h>
#endif
#include "aux_keyhelper.h"


void
KeyHelperForwarder::on_activate(void) {
  if (QCopChannel::isRegistered("QPE/KeyHelper")) {
    // instruct KeyHelper to send back key events to IMKit
    QCopEnvelope envelope("QPE/KeyHelper", "hook(QString)");

    envelope << QString("QPE/IME");
  }
}

void
KeyHelperForwarder::on_deactivate(void) {
  if (QCopChannel::isRegistered("QPE/KeyHelper")) {
    QCopEnvelope envelope("QPE/KeyHelper", "unhook()");
  }
}

void
KeyHelperForwarder::on_input(QKeyEvent &e) {
  if (QCopChannel::isRegistered("QPE/KeyHelper")) {
    forward(e);
    e.accept();
  }
}

void
KeyHelperForwarder::forward(QKeyEvent &e) {
  QCopEnvelope envelope("QPE/KeyHelper", "event(int,int,int,int,int)");
  int unicode, modifiers;
  bool is_press;

  unicode = e.text().at(0).unicode();
  modifiers = e.state();
  is_press = (e.type() == QEvent::KeyPress);

  envelope << unicode << e.key() << modifiers 
           << (int)is_press << (int)e.isAutoRepeat();
}

KeyHelperForwarder::KeyHelperForwarder(void) {
}

KeyHelperForwarder::~KeyHelperForwarder(void) {
  deactivate();
}

void
KeyHelperForwarder::slot_activate(bool activity) {
  activate(activity);
}
