// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE9 $
// $Id: imwidget.cpp,v 1.5 2004/03/07 07:07:43 yamaken Exp $

#include <qapplication.h>
#include "imwidget.h"


QSize
imkit_screen_size(void) {
  return qApp->desktop()->size();
}

void
ActivatableQWidgetAdapter::set_activity(bool activity) {
  if (widget()) {
    if (activity) {
      widget()->show();
    } else {
      widget()->hide();
    }
  }
}

ActivatableQWidgetAdapter::ActivatableQWidgetAdapter(void) {
}

ActivatableQWidgetAdapter::~ActivatableQWidgetAdapter(void) {
}

bool
ActivatableQWidgetAdapter::is_active(void) const {
  const QWidget *const_widget;

  const_widget = ((ActivatableQWidgetAdapter *)this)->widget();

  return (const_widget && const_widget->isVisible());
}

Preedit::Preedit(void) : QObject(NULL, "Preedit") {
}

Preedit::~Preedit(void) {
}

InputMapIndicator::InputMapIndicator(void)
  : QObject(NULL, "InputMapIndicator")
{
}

InputMapIndicator::~InputMapIndicator(void) {
}

CandidateWindow::CandidateWindow(void) : QObject(NULL, "CandidateWindow") {
}

CandidateWindow::~CandidateWindow(void) {
}

PixmapRepository::PixmapRepository(void) {
}

PixmapRepository::~PixmapRepository(void) {
}

bool
InputMaskFilter::eventFilter(QObject *event_receiver, QEvent *e) {
  bool stopped;

  switch (e->type()) {
  case QEvent::MouseButtonPress:
  case QEvent::MouseButtonRelease:
  case QEvent::MouseButtonDblClick:
  case QEvent::MouseMove:
  case QEvent::KeyPress:
  case QEvent::KeyRelease:
  case QEvent::FocusIn:
  case QEvent::FocusOut:
  case QEvent::Enter:
  case QEvent::Leave:
  case QEvent::Wheel:
  case QEvent::DragEnter:
  case QEvent::DragMove:
  case QEvent::DragLeave:
  case QEvent::Drop:
  case QEvent::DragResponse:
    return (stopped = true);

  default:
    return (stopped = false);
  }
}
