// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_5 $
// $Id: platform_qpe.h,v 1.17 2004/03/11 03:44:04 yamaken Exp $

#ifndef IMKIT_PLATFORM_QPE_H
#define IMKIT_PLATFORM_QPE_H

#include <qmap.h>
#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qwindowsystem_qws.h>
#include <qcopchannel_qws.h>
#include <qpe/inputmethodinterface.h>
#include "keyfilter.h"
#include "ui.h"
#include "ui_std.h"
#include "aux_keyhelper.h"

typedef IMUserInterface *(*imkit_create_custom_ui_t)(StdIMWidgetFactory *elem_factory);


#define IMKIT_EXPORT_INTERFACE(ui_creator, icon) \
  Q_EXPORT_INTERFACE() { \
    return IMKitGlobal::export_interface(ui_creator, icon); \
  }


class IMKitImpl;

class IMKitGlobal {
protected:
  static int reentrance_count;
  static int plugin_enumeration_count;
  static QMap<QString, int> resources;
  static QStringList *_enabled_plugins;
  static QString orig_lang;
  static QString fallback_lang;
  static QCopChannel *channel;

public:
  static int ref_resource(const QString &resource);
  static int unref_resource(const QString &resource);
  static void ref(void);
  static void unref(void);
  static QUnknownInterface *create_instance(imkit_create_custom_ui_t ui_creator,
                                            QPixmap *icon);
  static QUnknownInterface *export_interface(imkit_create_custom_ui_t ui_creator,
                                             QPixmap *icon);
  static QStringList *enabled_plugins(void);
  static QString currently_loading_plugin_name(void);
  static QString translator_path(const QString &lang, const QString &im_name);
  static void setup_translator(const QString &im_name);
  static void plugin_loading_has_been_started(const QString &plugin_lang);
  static void plugin_loading_has_been_finished(void);
  static void register_to_channel(QObject *receiver);
};


class KeyInjector
  : public QObject, public CascadeKeyFilter, public StdActivatable,
    public QWSServer::KeyboardFilter
{
  Q_OBJECT

protected:
  KeyEventConverter keyevent_converter;

public:
  KeyInjector(QObject *parent = NULL, const char *name = "KeyInjector");
  virtual ~KeyInjector(void);
  virtual bool filter(int unicode, int keycode, int modifiers,
                      bool is_press, bool autorepeat);

public slots:
  virtual void slot_activate(bool activity);
};


class QWSKeyBypassIn : public KeyInjector {
  Q_OBJECT

protected:
  bool keyfilter_is_registered;

protected:
  virtual void on_activate(void);
  virtual void on_deactivate(void);

public:
  QWSKeyBypassIn(void);
  virtual ~QWSKeyBypassIn(void);
};


class QWSKeyBypassOut
  : public QObject, public CascadeKeyFilter, public StdActivatable
{
  Q_OBJECT

protected:
  KeyEventConverter keyevent_converter;

protected:
  virtual void on_input(QKeyEvent &e);
  void emit_as_signal(QKeyEvent &e);

protected slots:
  virtual void emit_key(int unicode, int scancode, int modifiers,
                        bool is_press, bool autorepeat);

public:
  QWSKeyBypassOut(void);
  virtual ~QWSKeyBypassOut(void);
  virtual void input(QKeyEvent *e);

signals:
  void key(ushort unicode, ushort scancode, ushort modifiers,
           bool is_press, bool autorepeat);
};


// split from IMKitImpl to avoid troubles involving QObject
class IMKitQCopReceiver : public QObject {
  Q_OBJECT
  
protected:
  IMKitImpl *impl;
  
public:
  IMKitQCopReceiver(IMKitImpl *impl_init);
  
public slots:
  void qcopReceive(const QCString &msg, const QByteArray &data);
};


class IMKitImpl : public InputMethodInterface {
#ifndef QT_NO_COMPONENT
  Q_REFCOUNT
#endif

private:
  ulong ref;

protected:
  IMUserInterface *im_ui;
  imkit_create_custom_ui_t ui_creator;
  QPixmap *_icon;
  QWSKeyBypassIn *bypass_in;
  KeyHelperForwarder *forwarder;
  KeyInjector *injector;
  QWSKeyBypassOut *bypass_out;
  IMKitQCopReceiver *receiver;

private:
  IMKitImpl(void);

protected:
  virtual void init(void);
  virtual void prepare_key_bypass(void);
  virtual void join_to_bypass(CascadeKeyFilter *im_keyfilter);

public:
  IMKitImpl(imkit_create_custom_ui_t ui_creator_init, QPixmap *icon_init = 0);
  virtual ~IMKitImpl(void);
  virtual QWidget *inputMethod(QWidget *parent, Qt::WFlags flags);
  virtual void resetState(void);
  virtual QPixmap *icon(void);
  virtual QString name(void);
  virtual void onKeyPress(QObject *receiver, const char *slot);
  virtual void qcopReceive(const QCString &msg, const QByteArray &data);
#ifndef QT_NO_COMPONENT
  QRESULT queryInterface(const QUuid &uuid, QUnknownInterface **interface);
#endif
};

extern BidirMap<QString, InputMap> imkit_str2sym_inputmap;

#endif  // IMKIT_PLATFORM_QPE_H
