/*
 * 作成日: 2004/01/22
 */

/**
 * 点データを表すクラスです。
 * @author Kumano Tatsuo
 */
class PointData {
    /**
     * 三角点の図式分類コードを表す定数です。
     */
    public static int CLASSIFICATION_DATUMS = 7301; // 三角点

    /**
     * 駅の図式分類コードを表す定数です。
     */
    public static int CLASSIFICATION_STATION = 2420; // 駅

    /**
     * 不明な図式分類コードを表す定数です。
     */
    public static int CLASSIFICATION_UNKNOWN = 0; // 不明
    private String attribute; // 属性
    private double attributeX; // 属性を描画する x 座標
    private double attributeY; // 属性を描画する y 座標
    private int classificationCode; // 図式分類コード
    private String pointName; // 個別番号
    private double x; // x 座標
    private double y; // y 座標

    /**
     * 点を初期化します。
     * @param name 個別番号
     * @param code 図式分類コード
     * @param x x 座標
     * @param y y 座標
     */
    PointData(String name, int code, double x, double y) {
        pointName = name;
        classificationCode = code;
        this.x = x;
        this.y = y;
    }

    /**
     * 属性を取得します。
     * @return 属性
     */
    String getAttribute() {
        return attribute;
    }

    /**
     * 属性を描画する x 座標を取得します。
     * @return x 座標
     */
    public double getAttributeX() {
        return attributeX;
    }

    /**
     * 属性を描画する y 座標を取得します。
     * @return x 座標
     */
    public double getAttributeY() {
        return attributeY;
    }

    /**
     * 図式分類コードを取得します。
     * @return 図式分類コード
     */
    int getClassificationCode() {
        return classificationCode;
    }

    /**
     * 個別番号を取得します。
     * @return 個別番号
     */
    String getPointName() {
        return pointName;
    }

    /**
     * x 座標を取得します。
     * @return x 座標
     */
    double getX() {
        return x;
    }

    /**
     * y 座標を取得します。
     * @return y 座標
     */
    double getY() {
        return y;
    }

    /**
     * 属性を設定します。
     * @param string 属性
     */
    void setAttribute(String string) {
        attribute = string;
    }

    /**
     * 属性を描画する座標を設定します。
     * @param x x 座標
     * @param y y 座標
     */
    public void setAttributeLocation(double x, double y) {
        attributeX = x;
        attributeY = y;
    }

    /** このオブジェクトの文字列表現を取得します。
     * @return 文字列表現
     */
    public String toString() {
        return "[Point " + pointName + "(" + attribute + ")]";
    }
}
