package map;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URL;
import java.util.Arrays;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/05/03 9:07:02
 */
public class Const {

	/**
	 * ファイルシステムのセパレータ
	 */
	public static String SEPARATOR = File.separator;

	/**
	 * 地図を先読みする範囲
	 */
	public static final double preLoadCoefficient = 0;

	/**
	 * 一度読み込んだ地図を捨てずに置いておく範囲
	 */
	public static final double keepCoefficient = 1;

	/**
	 * 丁目のポリゴンデータを読み込む表示倍率
	 */
	public static final double loadGyouseiZoom = 0.15;

	/**
	 * 全てのデータを読み込む表示倍率 
	 */
	public static final double loadAllZoom = 0.3;

	/**
	 * 地図データの配布URL 
	 */
	public static final String BASE_URL = "http://sdf.gsi.go.jp/";

	/**
	 * キャッシュディレクトリの相対パス 
	 */
	public static final String CACHE_DIR = ".map" + File.separator + "cache";

	/**
	 * 展開済みファイルの一覧を記録したファイル
	 */
	public static final String EXTRACTED_LOG_FILE = CACHE_DIR + File.separator + "extractedfiles.txt";
	
	/**
	 * ファイルの一覧が記載されているファイル
	 */
	public static final URL FILE_LIST = Const.class.getResource("files.csv");

	/**
	 * コンポーネント間の隙間[px]
	 */
	public static final int GAP = 4;

	/**
	 * ゴシック体のフォント
	 */
	public static final String FONT_FAMILY_GOTHIC = Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("MS UI Gothic") ? "MS UI Gothic" : Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("Kochi Gothic") ? "Kochi Gothic" : "SansSerif";

	/**
	 * 明朝体のフォント
	 */
	public static final String FONT_FAMILY_MINCHO = Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("ＭＳ Ｐ明朝") ? "ＭＳ Ｐ明朝" : Arrays.asList(
			GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())
			.contains("Kochi Mincho") ? "Kochi Mincho" : "Serif";

	/**
	 * 緯度方向の倍率
	 */
	public static final double LATITUDE_ZOOM = 10500 / 0.09522051464134762;
	
	/**
	 * 経度方向の倍率
	 */
	public static final double LONGTITUDE_ZOOM = 18000 / 0.1963200593326917;
	
}
