/* Copyright © Charliecloud contributors.

   Memory management. */

#define _GNU_SOURCE
#pragma once

#include <stdbool.h>
#include <sys/types.h>

#include "misc.h"


/** Disallowed library functions **/

#define free FN_BLOCKED
#define fork FN_BLOCKED
#define malloc FN_BLOCKED
#define realloc FN_BLOCKED


/** Function prototypes **/

bool buf_zero_p(void *buf, size_t size);
void free_ch(void *p);
pid_t fork_ch(void);
void garbageinate(const char *when);
void *malloc_ch(size_t size, bool pointerful);
void *malloc_pointerful(size_t size);
void *malloc_zeroed(size_t size, bool pointerful);
void mem_exit(void);
void mem_init(void);
void mem_log(const char *when);
void *realloc_ch(void *p, size_t size, bool pointerful);
