/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

/*
 * These values are used by MediaTek internally.
 * We can find these registers in "MT6373TP_PMIC_Design_Notice_for_MT8196G_V0.2".
 * The setting values are provided by MeidaTek designers.
 */

#include <soc/mt6373.h>
#include <console/console.h>

static const struct mt6373_setting init_setting[] = {
	/* For VIO18 switch to DIG18 feature */
	{0xA95, 0x1, 0x1, 7},
	{0x16, 0xA, 0xA, 0},
	{0x19, 0x1F, 0x1F, 0},
	{0x21, 0x1, 0x1, 0},
	{0x22, 0x61, 0x61, 0},
	{0x4C, 0x0, 0xFF, 0},
	{0x4F, 0x0, 0x80, 0},
	{0x5A, 0x5, 0x5, 0},
	{0x91, 0x93, 0xFF, 0},
	{0x94, 0xFF, 0xFF, 0},
	{0x97, 0xF, 0xFF, 0},
	{0xC4, 0x0, 0x38, 0},
	{0xC7, 0x0, 0x3F, 0},
	{0xCA, 0x0, 0x3F, 0},
	{0xCD, 0x0, 0x3F, 0},
	{0xD0, 0x0, 0x3F, 0},
	{0xD3, 0x0, 0x3F, 0},
	{0xD6, 0x0, 0x3F, 0},
	{0x10F, 0x10, 0x10, 0},
	{0x112, 0x4, 0x4, 0},
	{0x12D, 0x1, 0x1, 0},
	{0x139, 0x21, 0x21, 0},
	{0x230, 0x0, 0x1, 0},
	{0x3A6, 0x3, 0x3, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x416, 0x12, 0xFF, 0},
	{0x417, 0x0, 0x7, 0},
	{0x90D, 0x10, 0x10, 0},
	{0xA17, 0xFF, 0xFF, 0},
	{0xA18, 0xFF, 0xFF, 0},
	{0xA19, 0xFC, 0xFC, 0},
	{0xA1D, 0xE, 0xFF, 0},
	{0xA1E, 0x7, 0xFF, 0},
	{0xA1F, 0x0, 0xFF, 0},
	{0xA20, 0xFF, 0xFF, 0},
	{0xA21, 0xE, 0xFF, 0},
	{0xA22, 0xFF, 0xFF, 0},
	{0xA23, 0xFF, 0xFF, 0},
	{0xA24, 0xC, 0xFF, 0},
	{0xA25, 0xB, 0xFF, 0},
	{0xA26, 0xA, 0xFF, 0},
	{0xA27, 0x7, 0xFF, 0},
	{0xA28, 0x7, 0xFF, 0},
	{0xA29, 0x7, 0xFF, 0},
	{0xA2A, 0x5, 0xFF, 0},
	{0xA2B, 0xFF, 0xFF, 0},
	{0xA2C, 0xFF, 0xFF, 0},
	{0xA2D, 0xFF, 0xFF, 0},
	{0xA2E, 0xFF, 0xFF, 0},
	{0xA2F, 0xFF, 0xFF, 0},
	{0xA30, 0xFF, 0xFF, 0},
	{0xA31, 0xFF, 0xFF, 0},
	{0xA32, 0xFF, 0xFF, 0},
	{0xA33, 0xFF, 0xFF, 0},
	{0xF8C, 0x15, 0x15, 0},
	{0xF8D, 0x25, 0x25, 0},
	{0x1188, 0x0, 0x80, 0},
	{0x1190, 0x13, 0xFF, 0},
	{0x119B, 0x20, 0xFF, 0},
	{0x119D, 0x60, 0x70, 0},
	{0x11A0, 0x60, 0x70, 0},
	{0x11C6, 0xF, 0xF, 0},
	{0x11C7, 0x0, 0xF, 0},
	{0x140E, 0x0, 0x40, 0},
	{0x144A, 0x0, 0xFF, 0},
	{0x144B, 0x0, 0xFF, 0},
	{0x144C, 0x0, 0xF, 0},
	{0x1487, 0x40, 0xFF, 0},
	{0x1488, 0x0, 0x1, 0},
	{0x148A, 0x5, 0x7F, 0},
	{0x1507, 0x40, 0xFF, 0},
	{0x1508, 0x0, 0x1, 0},
	{0x150A, 0x5, 0x7F, 0},
	{0x1587, 0x40, 0xFF, 0},
	{0x1588, 0x0, 0x1, 0},
	{0x158A, 0x5, 0x7F, 0},
	{0x1607, 0x40, 0xFF, 0},
	{0x1608, 0x0, 0x1, 0},
	{0x160A, 0x5, 0x7F, 0},
	{0x1687, 0x40, 0xFF, 0},
	{0x1688, 0x0, 0x1, 0},
	{0x168B, 0xC, 0x7F, 0},
	{0x1707, 0x40, 0xFF, 0},
	{0x1708, 0x0, 0x1, 0},
	{0x170B, 0xC, 0x7F, 0},
	{0x1787, 0x92, 0xFF, 0},
	{0x1788, 0x0, 0x1, 0},
	{0x1807, 0x40, 0xFF, 0},
	{0x1808, 0x0, 0x1, 0},
	{0x180A, 0x5, 0x7F, 0},
	{0x1887, 0x6C, 0xFF, 0},
	{0x1888, 0x0, 0x1, 0},
	{0x188A, 0x19, 0x7F, 0},
	{0x188B, 0x33, 0x7F, 0},
	{0x1907, 0x98, 0xFF, 0},
	{0x1908, 0x0, 0x1, 0},
	{0x190A, 0x19, 0x7F, 0},
	{0x190B, 0x33, 0x7F, 0},
	{0x198A, 0x2E, 0x2F, 0},
	{0x198C, 0xF8, 0xF8, 0},
	{0x198D, 0x32, 0x3F, 0},
	{0x198F, 0xC, 0xC, 0},
	{0x1990, 0xED, 0xFF, 0},
	{0x1991, 0x10, 0xFF, 0},
	{0x1994, 0x2E, 0x2F, 0},
	{0x1996, 0xF8, 0xF8, 0},
	{0x1997, 0x32, 0x3F, 0},
	{0x1999, 0xC, 0xC, 0},
	{0x199A, 0xED, 0xFF, 0},
	{0x199B, 0x10, 0xFF, 0},
	{0x19A0, 0xF, 0xF, 0},
	{0x19A1, 0x45, 0xFF, 0},
	{0x19A2, 0x45, 0xFF, 0},
	{0x19A3, 0xC, 0xC, 0},
	{0x19B5, 0x5, 0x87, 0},
	{0x19BD, 0x85, 0x87, 0},
	{0x19C0, 0x0, 0x18, 0},
	{0x1A08, 0x10, 0x10, 0},
	{0x1A09, 0x2D, 0x2F, 0},
	{0x1A0A, 0xC1, 0xC1, 0},
	{0x1A0B, 0xFA, 0xFF, 0},
	{0x1A0C, 0x32, 0x3F, 0},
	{0x1A0E, 0xC, 0xC, 0},
	{0x1A0F, 0x77, 0xFF, 0},
	{0x1A10, 0xC0, 0xFF, 0},
	{0x1A11, 0x6B, 0x7F, 0},
	{0x1A12, 0x10, 0x10, 0},
	{0x1A13, 0x2D, 0x2F, 0},
	{0x1A14, 0xC1, 0xC1, 0},
	{0x1A15, 0xFA, 0xFF, 0},
	{0x1A16, 0x32, 0x3F, 0},
	{0x1A18, 0xC, 0xC, 0},
	{0x1A19, 0x77, 0xFF, 0},
	{0x1A1A, 0xC0, 0xFF, 0},
	{0x1A1B, 0x6B, 0x7F, 0},
	{0x1A1C, 0x10, 0x10, 0},
	{0x1A1D, 0x2D, 0x2F, 0},
	{0x1A1E, 0xC1, 0xC1, 0},
	{0x1A1F, 0xFA, 0xFF, 0},
	{0x1A20, 0x32, 0x3F, 0},
	{0x1A22, 0xC, 0xC, 0},
	{0x1A23, 0x77, 0xFF, 0},
	{0x1A24, 0xC0, 0xFF, 0},
	{0x1A25, 0x6B, 0x7F, 0},
	{0x1A26, 0x10, 0x10, 0},
	{0x1A27, 0x2D, 0x2F, 0},
	{0x1A28, 0xC1, 0xC1, 0},
	{0x1A29, 0xFA, 0xFF, 0},
	{0x1A2A, 0x32, 0x3F, 0},
	{0x1A2C, 0xC, 0xC, 0},
	{0x1A2D, 0x77, 0xFF, 0},
	{0x1A2E, 0xC0, 0xFF, 0},
	{0x1A2F, 0x6B, 0x7F, 0},
	{0x1A37, 0xFF, 0xFF, 0},
	{0x1A39, 0x5F, 0xFF, 0},
	{0x1A3A, 0x5F, 0xFF, 0},
	{0x1A3B, 0x5F, 0xFF, 0},
	{0x1A3C, 0x5F, 0xFF, 0},
	{0x1A3D, 0xF0, 0xF0, 0},
	{0x1A46, 0x6, 0x87, 0},
	{0x1A4E, 0x6, 0x87, 0},
	{0x1A56, 0x6, 0x87, 0},
	{0x1A5E, 0x6, 0x87, 0},
	{0x1A61, 0x0, 0x78, 0},
	{0x1A88, 0x10, 0x50, 0},
	{0x1A89, 0x2D, 0x2F, 0},
	{0x1A8B, 0xF8, 0xF8, 0},
	{0x1A8C, 0x32, 0x3F, 0},
	{0x1A8E, 0xC, 0xC, 0},
	{0x1A8F, 0xED, 0xFF, 0},
	{0x1A90, 0x0, 0xFF, 0},
	{0x1A92, 0x10, 0x10, 0},
	{0x1A93, 0x2D, 0x2F, 0},
	{0x1A95, 0xF8, 0xF8, 0},
	{0x1A96, 0x32, 0x3F, 0},
	{0x1A98, 0xC, 0xC, 0},
	{0x1A99, 0xED, 0xFF, 0},
	{0x1A9C, 0x10, 0x16, 0},
	{0x1A9D, 0x2D, 0x2F, 0},
	{0x1A9F, 0xF8, 0xF8, 0},
	{0x1AA0, 0x32, 0x3F, 0},
	{0x1AA2, 0xC, 0xC, 0},
	{0x1AA3, 0xED, 0xFF, 0},
	{0x1AA4, 0x0, 0xFF, 0},
	{0x1AA6, 0x10, 0x56, 0},
	{0x1AA7, 0x2D, 0x2F, 0},
	{0x1AA9, 0xF8, 0xF8, 0},
	{0x1AAA, 0x32, 0x3F, 0},
	{0x1AAC, 0xC, 0xC, 0},
	{0x1AAD, 0xED, 0xFF, 0},
	{0x1AB6, 0x20, 0x30, 0},
	{0x1AB7, 0xF0, 0xF0, 0},
	{0x1AB9, 0xCD, 0xFF, 0},
	{0x1ABA, 0xCD, 0xFF, 0},
	{0x1ABB, 0xE5, 0xFF, 0},
	{0x1ABC, 0xCD, 0xFF, 0},
	{0x1ABD, 0xF0, 0xF0, 0},
	{0x1AC6, 0x6, 0x87, 0},
	{0x1ACE, 0x86, 0x87, 0},
	{0x1AD6, 0x6, 0x87, 0},
	{0x1ADE, 0x6, 0x87, 0},
	{0x1AE1, 0x28, 0x78, 0},
	{0x1B0D, 0xF, 0xF, 0},
	{0x1B0E, 0x1, 0x1, 0},
	{0x1B10, 0xFF, 0xFF, 0},
	{0x1B13, 0xFF, 0xFF, 0},
	{0x1B16, 0xFF, 0xFF, 0},
	{0x1B2A, 0x8, 0x8, 0},
	{0x1B88, 0x10, 0x10, 0},
	{0x1B89, 0x0, 0x80, 0},
	{0x1B96, 0x10, 0x10, 0},
	{0x1B97, 0x0, 0x80, 0},
	{0x1BA4, 0x10, 0x10, 0},
	{0x1BA5, 0x0, 0x80, 0},
	{0x1BAA, 0x40, 0x40, 0},
	{0x1BB2, 0x10, 0x10, 0},
	{0x1BB3, 0x0, 0x80, 0},
	{0x1BC0, 0x10, 0x10, 0},
	{0x1BC1, 0x0, 0x80, 0},
	{0x1BCE, 0x10, 0x10, 0},
	{0x1BCF, 0x0, 0x80, 0},
	{0x1C08, 0x10, 0x10, 0},
	{0x1C09, 0x0, 0x80, 0},
	{0x1C16, 0x10, 0x10, 0},
	{0x1C17, 0x0, 0x80, 0},
	{0x1C24, 0x10, 0x10, 0},
	{0x1C25, 0x0, 0x80, 0},
	{0x1C32, 0x10, 0x10, 0},
	{0x1C33, 0x0, 0x80, 0},
	{0x1C40, 0x10, 0x10, 0},
	{0x1C41, 0x0, 0x80, 0},
	{0x1C4E, 0x10, 0x10, 0},
	{0x1C4F, 0x0, 0x80, 0},
	{0x1C88, 0x10, 0x10, 0},
	{0x1C89, 0x0, 0x80, 0},
	{0x1C96, 0x10, 0x10, 0},
	{0x1C97, 0x0, 0x80, 0},
	{0x1CA4, 0x10, 0x10, 0},
	{0x1CA5, 0x0, 0x80, 0},
	{0x1CB2, 0x10, 0x10, 0},
	{0x1CB3, 0x0, 0x80, 0},
	{0x1CC1, 0x10, 0x10, 0},
	{0x1CC2, 0x0, 0x80, 0},
	{0x1CCF, 0x10, 0x10, 0},
	{0x1CD0, 0x0, 0x80, 0},
	{0x1D08, 0x30, 0x30, 0},
	{0x1D09, 0x0, 0x80, 0},
	{0x1D16, 0x30, 0x30, 0},
	{0x1D17, 0x0, 0x80, 0},
	{0x1D24, 0x30, 0x30, 0},
	{0x1D25, 0x0, 0x80, 0},
	{0x1D32, 0x30, 0x30, 0},
	{0x1D33, 0x0, 0x80, 0},
	{0x1D41, 0x30, 0x30, 0},
	{0x1D42, 0x0, 0x80, 0},
	{0x1D88, 0x10, 0x10, 0},
	{0x1D89, 0x0, 0x80, 0},
	{0x1D91, 0xC, 0x7F, 0},
	{0x1D92, 0xC, 0x7F, 0},
	{0x1E0C, 0x0, 0xF, 0},
	{0x1E22, 0x1, 0x1, 0},
	{0x1E3A, 0x1, 0x1, 0},
	{0x1E3E, 0x1, 0x1, 0},
	{0x1E97, 0x2, 0x3, 0},
	{0x1E9B, 0x2, 0x3, 0},
	{0x1F0B, 0x8, 0xC, 0},
	{0x1F0F, 0x8, 0xC, 0},
	{0x1F8B, 0x8, 0xC, 0},
	{0x1F8F, 0x20, 0x30, 0},

	/* Add UVLO 2.0 setting. also need to modify dts setting for main pmic */
	{0xA36, 0x2, 0x2, 0},
	{0xA89, 0x5, 0xF, 0},
	{0xA8A, 0x3, 0xF, 0},
	{0xA95, 0x40, 0x40, 0},
};

static const struct mt6373_setting lp_setting[] = {
	/* Suspend */
	{0x14a0, 0x1, 0x1, 0x0},
	{0x1494, 0x1, 0x1, 0x0},
	{0x149a, 0x1, 0x1, 0x0},
	{0x15a0, 0x1, 0x1, 0x0},
	{0x1594, 0x1, 0x1, 0x0},
	{0x159a, 0x1, 0x1, 0x0},
	{0x1820, 0x1, 0x1, 0x0},
	{0x1814, 0x1, 0x1, 0x0},
	{0x181a, 0x1, 0x1, 0x0},
	{0x18a0, 0x1, 0x1, 0x0},
	{0x1894, 0x1, 0x1, 0x0},
	{0x189a, 0x1, 0x1, 0x0},
	{0x1cac, 0x1, 0x1, 0xa},
	{0x1cb2, 0x1, 0x1, 0x0},
	{0x1cb8, 0x1, 0x1, 0x0},
	{0x1bbe, 0x1, 0x1, 0xa},
	{0x1bc4, 0x1, 0x1, 0x0},
	{0x1bca, 0x1, 0x1, 0x0},
	{0x1d22, 0x1, 0x1, 0xe},
	{0x1d28, 0x0, 0x1, 0xe},
	{0x1c64, 0x1, 0x1, 0xa},
	{0x1c6a, 0x1, 0x1, 0x0},
	{0x1c70, 0x1, 0x1, 0x0},
	{0x1d34, 0x1, 0x1, 0xe},
	{0x1d3a, 0x0, 0x1, 0xe},
	{0x1c88, 0x1, 0x1, 0xa},
	{0x1c8e, 0x1, 0x1, 0x0},
	{0x1c94, 0x1, 0x1, 0x0},
	{0x1b9a, 0x1, 0x1, 0xa},
	{0x1ba0, 0x1, 0x1, 0x0},
	{0x1ba6, 0x1, 0x1, 0x0},
	{0x1d08, 0x1, 0x1, 0xa},
	{0x1d0e, 0x1, 0x1, 0x0},
	{0x1d14, 0x1, 0x1, 0x0},
	{0x1d0e, 0x1, 0x1, 0x0},
	{0x1d14, 0x1, 0x1, 0x0},
	{0x1d9a, 0x1, 0x1, 0xa},
	{0x1da0, 0x1, 0x1, 0x0},
	{0x1da6, 0x1, 0x1, 0x0},

	/* Deep idle */
	{0x1bbe, 0x1, 0x1, 0xc},
	{0x1bc4, 0x1, 0x1, 0x2},
	{0x1bca, 0x1, 0x1, 0x2},
	{0x1c64, 0x1, 0x1, 0xc},
	{0x1c6a, 0x1, 0x1, 0x2},
	{0x1c70, 0x1, 0x1, 0x2},
	{0x1c88, 0x1, 0x1, 0xc},
	{0x1c8e, 0x1, 0x1, 0x2},
	{0x1c94, 0x1, 0x1, 0x2},
	{0x1b9a, 0x1, 0x1, 0xc},
	{0x1ba0, 0x1, 0x1, 0x2},
	{0x1ba6, 0x1, 0x1, 0x2},
	{0x1d08, 0x1, 0x1, 0xc},
	{0x1d0e, 0x1, 0x1, 0x2},
	{0x1d14, 0x1, 0x1, 0x2},
	{0x1d0e, 0x1, 0x1, 0x2},
	{0x1d14, 0x1, 0x1, 0x2},
};

void mt6373_init_setting(void)
{
	for (int i = 0; i < ARRAY_SIZE(init_setting); i++)
		mt6373_write_field(init_setting[i].addr, init_setting[i].val,
				   init_setting[i].mask, init_setting[i].shift);
	printk(BIOS_INFO, "%s done\n", __func__);
}

void mt6373_lp_setting(void)
{
	for (int i = 0; i < ARRAY_SIZE(lp_setting); i++)
		mt6373_write_field(lp_setting[i].addr, lp_setting[i].val,
				   lp_setting[i].mask, lp_setting[i].shift);
}
