struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 1086,
		.content = "processor\t: 0\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 4\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 5\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 1248,
		.content = "processor\t: 0\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt evtstrm\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt evtstrm\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt evtstrm\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt evtstrm\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 4\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt evtstrm\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "processor\t: 5\n"
			   "BogoMIPS\t: 52.16\n"
			   "Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt evtstrm\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 4\n"
			   "\n",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 5397,
		.content = "\n"
			   "# begin build properties\n"
			   "# autogenerated by buildinfo.sh\n"
			   "ro.build.id=N2G47J\n"
			   "ro.build.display.id=N2G47J\n"
			   "ro.build.version.incremental=V8.5.3.0.0.NCJCNED\n"
			   "ro.build.version.sdk=25\n"
			   "ro.build.version.preview_sdk=0\n"
			   "ro.build.version.codename=REL\n"
			   "ro.build.version.all_codenames=REL\n"
			   "ro.build.version.release=7.1.2\n"
			   "ro.build.version.security_patch=2017-05-01\n"
			   "ro.build.version.base_os=\n"
			   "ro.build.date=Thu Jun 15 10:24:29 CST 2017\n"
			   "ro.build.date.utc=1497493469\n"
			   "ro.build.type=user\n"
			   "ro.build.user=builder\n"
			   "ro.build.host=c3-miui-ota-bd09.bj\n"
			   "ro.build.tags=release-keys\n"
			   "ro.build.flavor=song-user\n"
			   "ro.product.model=MI 5C\n"
			   "ro.product.brand=Xiaomi\n"
			   "ro.product.name=meri\n"
			   "ro.product.device=song\n"
			   "ro.product.mod_device=meri_global\n"
			   "ro.product.board=\n"
			   "# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			   "# use ro.product.cpu.abilist instead.\n"
			   "ro.product.cpu.abi=arm64-v8a\n"
			   "ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			   "ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			   "ro.product.cpu.abilist64=arm64-v8a\n"
			   "ro.product.locale=en-US\n"
			   "ro.wifi.channels=\n"
			   "ro.board.platform=song\n"
			   "# ro.build.product is obsolete; use ro.product.device\n"
			   "ro.build.product=song\n"
			   "# Do not try to parse description, fingerprint, or thumbprint\n"
			   "ro.build.description=song-user 7.1.2 N2G47J V8.5.3.0.0.NCJCNED release-keys\n"
			   "ro.build.fingerprint=Xiaomi/meri/meri:7.1.2/N2G47J/V8.5.3.0.0.NCJCNED:user/release-keys\n"
			   "ro.build.characteristics=nosdcard\n"
			   "# end build properties\n"
			   "#\n"
			   "# from device/pinecone/song/system.prop\n"
			   "#\n"
			   "# This overrides settings in the products/generic/system.prop file\n"
			   "#\n"
			   "# rild.libpath=/system/lib/libreference-ril.so\n"
			   "# rild.libargs=-d /dev/ttyS0\n"
			   "ro.sf.lcd_density=480\n"
			   "ro.opengles.version=196610\n"
			   "ro.telephony.default_network=9\n"
			   "ro.ril.modem.pb=0\n"
			   "\n"
			   "# disable strictmode\n"
			   "persist.sys.strictmode.disable=true\n"
			   "mali.hwc.flattener.interval=900\n"
			   "mali.hwc.flattener.enable=1\n"
			   "mali.hwc.rotation.size=69120\n"
			   "\n"
			   "# disable ap log\n"
			   "persist.sys.song.log=/data/local/log,I1,0,0,I2,0,0,I3,0,0,I4,0,0,I5,0,0,I6,0,0\n"
			   "\n"
			   "# dirac\n"
			   "ro.dirac.acs.controller=afm\n"
			   "ro.dirac.acs.storeSettings=1\n"
			   "ro.dirac.afm.mode=global\n"
			   "ro.dirac.config=66\n"
			   "#ro.dirac.max_active.headset=3\n"
			   "#ro.dirac.max_active.powersound=2\n"
			   "ro.dirac.poolsize=2\n"
			   "\n"
			   "# button jack mode & switch\n"
			   "persist.sys.button_jack_profile=volume\n"
			   "persist.sys.button_jack_switch=0\n"
			   "\n"
			   "#power optimize\n"
			   "persist.sys.power.optimize=1\n"
			   "\n"
			   "#hardware ui\n"
			   "debug.hwui.en_partial_updates=false\n"
			   "\n"
			   "# display features\n"
			   "ro.sys.display.support=59\n"
			   "\n"
			   "#hwui properties\n"
			   "ro.hwui.texture_cache_size=72\n"
			   "ro.hwui.layer_cache_size=48\n"
			   "ro.hwui.r_buffer_cache_size=8\n"
			   "ro.hwui.path_cache_size=32\n"
			   "ro.hwui.gradient_cache_size=1\n"
			   "ro.hwui.drop_shadow_cache_size=6\n"
			   "ro.hwui.texture_cache_flushrate=0.4\n"
			   "ro.hwui.text_small_cache_width=1024\n"
			   "ro.hwui.text_small_cache_height=1024\n"
			   "ro.hwui.text_large_cache_width=2048\n"
			   "ro.hwui.text_large_cache_height=1024\n"
			   "\n"
			   "#telephony process\n"
			   "log.tag.InCall=V\n"
			   "\n"
			   "#volume step\n"
			   "ro.config.vc_call_vol_steps=11\n"
			   "\n"
			   "# load 3 mode nvram by default\n"
			   "persist.sys.proj.nvram.mode=3\n"
			   "\n"
			   "# art threads\n"
			   "dalvik.vm.boot-dex2oat-threads=4\n"
			   "dalvik.vm.dex2oat-threads=4\n"
			   "dalvik.vm.image-dex2oat-threads=4\n"
			   "\n"
			   "#\n"
			   "# ADDITIONAL_BUILD_PROPERTIES\n"
			   "#\n"
			   "ro.miui.version.code_time=1492617600\n"
			   "ro.miui.ui.version.code=6\n"
			   "ro.miui.ui.version.name=V8\n"
			   "dalvik.vm.dex2oat-filter=\n"
			   "persist.radio.multisim.config=dsds\n"
			   "persist.logd.size.radio=2M\n"
			   "persist.logd.size.main=2M\n"
			   "persist.logd.size.system=2M\n"
			   "persist.dbg.allow_ims_off=1\n"
			   "ro.setupwizard.mode=OPTIONAL\n"
			   "ro.product.first_api_level=23\n"
			   "dalvik.vm.heapstartsize=8m\n"
			   "dalvik.vm.heapgrowthlimit=192m\n"
			   "dalvik.vm.heapsize=512m\n"
			   "dalvik.vm.heaptargetutilization=0.75\n"
			   "dalvik.vm.heapminfree=512k\n"
			   "dalvik.vm.heapmaxfree=8m\n"
			   "wifi.interface=wlan0\n"
			   "persist.sys.song.msms=221\n"
			   "persist.sys.song.standby.rat=7,3\n"
			   "persist.sys.song.dual2single=1\n"
			   "persist.sys.song.dynamic.rat=1\n"
			   "persist.sys.song.master.card=10\n"
			   "persist.sys.song.check.imei=1\n"
			   "persist.sys.initial.pdp.type=3\n"
			   "persist.ims.ut.enable=1\n"
			   "ffmpeg.force.decodersource=audio\n"
			   "persist.radio.elog.path=1\n"
			   "persist.sys.elog.auto.run=0\n"
			   "persist.sys.calls.on.ims=true\n"
			   "ro.carrier=unknown\n"
			   "ro.ril.hsxpa=1\n"
			   "ro.ril.gprsclass=10\n"
			   "ro.adb.qemud=1\n"
			   "persist.sys.mcd_config_file=/system/etc/mcd_default.conf\n"
			   "persist.sys.perf.debug=true\n"
			   "ro.ss.version=5.1.111-004\n"
			   "ro.ss.nohidden=true\n"
			   "persist.sys.dalvik.vm.lib.2=libart.so\n"
			   "dalvik.vm.isa.arm64.variant=generic\n"
			   "dalvik.vm.isa.arm64.features=default\n"
			   "dalvik.vm.isa.arm.variant=cortex-a15\n"
			   "dalvik.vm.isa.arm.features=default\n"
			   "net.bt.name=Android\n"
			   "dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			   "ro.miui.has_real_blur=1\n"
			   "ro.miui.has_handy_mode_sf=1\n"
			   "fw.max_users=5\n"
			   "ro.product.mod_device=meri_global\n"
			   "ro.config.sms_received_sound=FadeIn.ogg\n"
			   "ro.config.sms_delivered_sound=MessageComplete.ogg\n"
			   "ro.com.android.mobiledata=false\n"
			   "ro.product.manufacturer=Xiaomi\n"
			   "ro.config.elder-ringtone=Angel.mp3\n"
			   "keyguard.no_require_sim=true\n"
			   "ro.com.android.dataroaming=false\n"
			   "persist.sys.mitalk.enable=true\n"
			   "ro.config.ringtone=Ring_Synth_04.ogg\n"
			   "ro.config.notification_sound=pixiedust.ogg\n"
			   "ro.config.alarm_alert=Alarm_Classic.ogg\n"
			   "ro.product.cuptsm=XIAOMI|ESE|02|01\n"
			   "qemu.hw.mainkeys=1\n"
			   "persist.dbg.volte_avail_ovr=1\n"
			   "persist.dbg.vt_avail_ovr=1\n"
			   "persist.sys.handy_mode_cct=160\n"
			   "ro.config.max_starting_bg=4\n"
			   "persist.added_boot_bgservices=4\n"
			   "ro.com.google.clientidbase=android-xiaomi\n"
			   "ro.expect.recovery_id=0x69417ef0f89bc80082ed241388a04ba1581a1182376d101747b4a3bb8171d7e8\n"
			   "\n"
			   "persist.sys.timezone=America/New_York\n"
			   "ro.product.locale.language=en\n"
			   "ro.product.locale.region=US\n"
			   "ro.miui.region=US\n"
			   "ro.miui.mcc=9310\n"
			   "ro.miui.mnc=9999\n"
			   "ro.miui.cust_variant=us\n"
			   "\n"
			   "ro.adb.secure=1\n"
			   "persist.adb.notify=0\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 4,
		.content = "6-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-5\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 409,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\tcpu4\t\tcpu5\t\tcpu6\t\tcpu7\t\t\n"
			   "460800\t\t3124\t\t3124\t\t3124\t\t3124\t\tN/A\t\tN/A\t\t\n"
			   "624000\t\t165\t\t165\t\t165\t\t165\t\tN/A\t\tN/A\t\t\n"
			   "1248000\t\t6344\t\t6344\t\t6344\t\t6344\t\tN/A\t\tN/A\t\t\n"
			   "1404000\t\t86\t\t86\t\t86\t\t86\t\tN/A\t\tN/A\t\t\n"
			   "1843200\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t8105\t\t8105\t\t\n"
			   "1950000\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t0\t\t0\t\t\n"
			   "2002000\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t0\t\t0\t\t\n"
			   "2106000\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t14\t\t14\t\t\n"
			   "2158000\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t180\t\t180\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 116,
		.content = "CPU0:460800=46 624000=70 1248000=174 1404000=217 \n"
			   "CPU4:1843200=300 1950000=352 2002000=370 2106000=421 2158000=470 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 11,
		.content = "arm64_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1404000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 31,
		.content = "460800 624000 1248000 1404000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 13,
		.content = "song-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 47,
		.content = "460800 3240\n"
			   "624000 165\n"
			   "1248000 6358\n"
			   "1404000 86\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "152\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1404000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 31,
		.content = "460800 624000 1248000 1404000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 13,
		.content = "song-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 47,
		.content = "460800 3445\n"
			   "624000 194\n"
			   "1248000 6358\n"
			   "1404000 86\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "154\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1404000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 31,
		.content = "460800 624000 1248000 1404000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 13,
		.content = "song-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 47,
		.content = "460800 3671\n"
			   "624000 194\n"
			   "1248000 6368\n"
			   "1404000 86\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "156\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1404000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 31,
		.content = "460800 624000 1248000 1404000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 13,
		.content = "song-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "460800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 47,
		.content = "460800 3914\n"
			   "624000 194\n"
			   "1248000 6368\n"
			   "1404000 86\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "156\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/affected_cpus",
		.size = 4,
		.content = "4 5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2158000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_min_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "78536\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_frequencies",
		.size = 41,
		.content = "1843200 1950000 2002000 2106000 2158000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_driver",
		.size = 13,
		.content = "song-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/time_in_state",
		.size = 54,
		.content = "1843200 6013\n"
			   "1950000 0\n"
			   "2002000 0\n"
			   "2106000 1\n"
			   "2158000 54\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/total_trans",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings_list",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/affected_cpus",
		.size = 4,
		.content = "4 5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2158000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_min_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "78536\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_frequencies",
		.size = 41,
		.content = "1843200 1950000 2002000 2106000 2158000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_driver",
		.size = 13,
		.content = "song-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_min_freq",
		.size = 8,
		.content = "1843200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/time_in_state",
		.size = 54,
		.content = "1843200 6264\n"
			   "1950000 0\n"
			   "2002000 0\n"
			   "2106000 1\n"
			   "2158000 54\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/total_trans",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings",
		.size = 3,
		.content = "20\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings_list",
		.size = 2,
		.content = "5\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "dalvik.vm.appimageformat",
		.value = "lz4",
	},
	{
		.key = "dalvik.vm.boot-dex2oat-threads",
		.value = "4",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.dex2oat-filter",
		.value = "",
	},
	{
		.key = "dalvik.vm.dex2oat-threads",
		.value = "4",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "192m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "512k",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-threads",
		.value = "4",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a15",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "generic",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "dalvik.vm.usejit",
		.value = "true",
	},
	{
		.key = "dalvik.vm.usejitprofiles",
		.value = "true",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwui.en_partial_updates",
		.value = "false",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "events.cpu",
		.value = "true",
	},
	{
		.key = "ffmpeg.force.decodersource",
		.value = "audio",
	},
	{
		.key = "fw.max_users",
		.value = "5",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.network.type",
		.value = "EDGE,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.operator.orig.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "ABIES.R10.T46-be91e70-141f514",
	},
	{
		.key = "gsm.version.baseband1",
		.value = "ABIES.R10.T46-be91e70-141f514",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android reference-ril 1.0",
	},
	{
		.key = "ims.ecclist",
		.value = "",
	},
	{
		.key = "ims.emergency.service",
		.value = "0",
	},
	{
		.key = "ims.ut.registered",
		.value = "0",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.audioserver",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bt_init",
		.value = "stopped",
	},
	{
		.key = "init.svc.cameraserver",
		.value = "running",
	},
	{
		.key = "init.svc.clear-bcb",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.displayfeature",
		.value = "running",
	},
	{
		.key = "init.svc.dns_eth0",
		.value = "stopped",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.emsd",
		.value = "running",
	},
	{
		.key = "init.svc.fdpp",
		.value = "running",
	},
	{
		.key = "init.svc.fingerprintd",
		.value = "running",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.gps-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.iild",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lcvmserver",
		.value = "running",
	},
	{
		.key = "init.svc.leds-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.mcd_init",
		.value = "stopped",
	},
	{
		.key = "init.svc.mcd_service",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mediacodec",
		.value = "running",
	},
	{
		.key = "init.svc.mediadrm",
		.value = "running",
	},
	{
		.key = "init.svc.mediaextractor",
		.value = "running",
	},
	{
		.key = "init.svc.mlipayservice",
		.value = "running",
	},
	{
		.key = "init.svc.mqsasd",
		.value = "running",
	},
	{
		.key = "init.svc.mtservice",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.otad",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.radio_config",
		.value = "running",
	},
	{
		.key = "init.svc.rild0",
		.value = "running",
	},
	{
		.key = "init.svc.rild1",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.shelld",
		.value = "running",
	},
	{
		.key = "init.svc.smeloop",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-elog-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-mla-manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-oms-mla0",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-oms-mla1",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-oms-mla2",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-oms-mla3",
		.value = "stopped",
	},
	{
		.key = "init.svc.song-oms-sa",
		.value = "running",
	},
	{
		.key = "init.svc.song-thermal",
		.value = "running",
	},
	{
		.key = "init.svc.ssService",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.tee_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wifi_init",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "log.tag.InCall",
		.value = "V",
	},
	{
		.key = "mali.hwc.flattener.enable",
		.value = "1",
	},
	{
		.key = "mali.hwc.flattener.interval",
		.value = "900",
	},
	{
		.key = "mali.hwc.rotation.size",
		.value = "69120",
	},
	{
		.key = "mcd.extra.params",
		.value = "",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.lte.ims.data.enabled",
	},
	{
		.key = "net.hostname",
		.value = "MI5C-MiPhone",
	},
	{
		.key = "net.lte.ims.data.enabled",
		.value = "true",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.adb.notify",
		.value = "0",
	},
	{
		.key = "persist.added_boot_bgservices",
		.value = "4",
	},
	{
		.key = "persist.camera.module.info",
		.value = "back_camera=ov12870,front_camera=ov8865",
	},
	{
		.key = "persist.dbg.allow_ims_off",
		.value = "1",
	},
	{
		.key = "persist.dbg.volte_avail_ovr",
		.value = "0",
	},
	{
		.key = "persist.dbg.vt_avail_ovr",
		.value = "1",
	},
	{
		.key = "persist.ims.ut.enable",
		.value = "1",
	},
	{
		.key = "persist.logd.prunelist",
		.value = "1000 1013 1001",
	},
	{
		.key = "persist.logd.size.main",
		.value = "2M",
	},
	{
		.key = "persist.logd.size.radio",
		.value = "2M",
	},
	{
		.key = "persist.logd.size.system",
		.value = "2M",
	},
	{
		.key = "persist.radio.elog.path",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.song.master.card",
		.value = "10",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "ac:c1:ee:fc:b3:cc",
	},
	{
		.key = "persist.sys.button_jack_profile",
		.value = "volume",
	},
	{
		.key = "persist.sys.button_jack_switch",
		.value = "0",
	},
	{
		.key = "persist.sys.calls.on.ims",
		.value = "true",
	},
	{
		.key = "persist.sys.cucc.gsm.3mode",
		.value = "0",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.display_cabc",
		.value = "1",
	},
	{
		.key = "persist.sys.display_ce",
		.value = "10",
	},
	{
		.key = "persist.sys.display_eyecare",
		.value = "0",
	},
	{
		.key = "persist.sys.display_prefer",
		.value = "2",
	},
	{
		.key = "persist.sys.elog.auto.run",
		.value = "0",
	},
	{
		.key = "persist.sys.enable_pinfile",
		.value = "true",
	},
	{
		.key = "persist.sys.gamut_mode",
		.value = "0",
	},
	{
		.key = "persist.sys.handy_mode_cct",
		.value = "160",
	},
	{
		.key = "persist.sys.ifaa",
		.value = "0",
	},
	{
		.key = "persist.sys.initial.pdp.type",
		.value = "3",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.ltm_enable",
		.value = "true",
	},
	{
		.key = "persist.sys.mcd_config_file",
		.value = "/system/etc/mcd_default.conf",
	},
	{
		.key = "persist.sys.memctrl",
		.value = "supported",
	},
	{
		.key = "persist.sys.mitalk.enable",
		.value = "true",
	},
	{
		.key = "persist.sys.notification_device",
		.value = "453",
	},
	{
		.key = "persist.sys.notification_num",
		.value = "3",
	},
	{
		.key = "persist.sys.notification_rank",
		.value = "0",
	},
	{
		.key = "persist.sys.perf.debug",
		.value = "true",
	},
	{
		.key = "persist.sys.power.optimize",
		.value = "1",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.proj.nvram.mode",
		.value = "3",
	},
	{
		.key = "persist.sys.screenshot_mode",
		.value = "1",
	},
	{
		.key = "persist.sys.silent",
		.value = "0",
	},
	{
		.key = "persist.sys.sim2.master.enable",
		.value = "0",
	},
	{
		.key = "persist.sys.smartcover_mode",
		.value = "1",
	},
	{
		.key = "persist.sys.song.actual.rat",
		.value = "7,1",
	},
	{
		.key = "persist.sys.song.check.imei",
		.value = "0",
	},
	{
		.key = "persist.sys.song.dual2single",
		.value = "1",
	},
	{
		.key = "persist.sys.song.dynamic.rat",
		.value = "1",
	},
	{
		.key = "persist.sys.song.log",
		.value = "/data/local/log,I1,0,0,I2,0,0,I3,0,0,I4,0,0,I5,0,0,I6,0,0",
	},
	{
		.key = "persist.sys.song.master.card",
		.value = "10",
	},
	{
		.key = "persist.sys.song.msms",
		.value = "221",
	},
	{
		.key = "persist.sys.song.proj.rat",
		.value = "gsm,tdscdma,lte_tdd",
	},
	{
		.key = "persist.sys.song.standby.rat",
		.value = "7,3",
	},
	{
		.key = "persist.sys.strictmode.disable",
		.value = "true",
	},
	{
		.key = "persist.sys.task_isolation",
		.value = "true",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "adb",
	},
	{
		.key = "persist.sys.webview.vmsize",
		.value = "124435184",
	},
	{
		.key = "pm.dexopt.ab-ota",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.bg-dexopt",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.boot",
		.value = "verify-profile",
	},
	{
		.key = "pm.dexopt.core-app",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.first-boot",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.forced-dexopt",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.install",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.nsys-library",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.shared-apk",
		.value = "speed",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "1",
	},
	{
		.key = "radio.start.state",
		.value = "started",
	},
	{
		.key = "ril.1.first_connected",
		.value = "false",
	},
	{
		.key = "ril.2.first_connected",
		.value = "false",
	},
	{
		.key = "ril.ecclist",
		.value = "120,122,112,911,000,08,110,118,119,999",
	},
	{
		.key = "ril.ecclist1",
		.value = "120,122,112,911,000,08,110,118,119,999",
	},
	{
		.key = "ril.emsd.init.complete.flag0",
		.value = "0",
	},
	{
		.key = "ril.emsd.init.complete.flag1",
		.value = "0",
	},
	{
		.key = "rild.send.cfun",
		.value = "1",
	},
	{
		.key = "ro.adb.qemud",
		.value = "1",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "song",
	},
	{
		.key = "ro.boot.bl_state",
		.value = "0",
	},
	{
		.key = "ro.boot.board-id",
		.value = "14",
	},
	{
		.key = "ro.boot.corner-info",
		.value = "5",
	},
	{
		.key = "ro.boot.cpub-freq",
		.value = "2",
	},
	{
		.key = "ro.boot.cpuid",
		.value = "0x21088866e62774",
	},
	{
		.key = "ro.boot.cpul-volt",
		.value = "1",
	},
	{
		.key = "ro.boot.flash.locked",
		.value = "1",
	},
	{
		.key = "ro.boot.gpu-volt",
		.value = "1",
	},
	{
		.key = "ro.boot.hardware",
		.value = "song",
	},
	{
		.key = "ro.boot.secureboot",
		.value = "1",
	},
	{
		.key = "ro.boot.serialno",
		.value = "1d1fb852",
	},
	{
		.key = "ro.boot.soc-class",
		.value = "1",
	},
	{
		.key = "ro.boot.soc-id",
		.value = "1",
	},
	{
		.key = "ro.boot.soc-rev",
		.value = "1",
	},
	{
		.key = "ro.boot.soc-type",
		.value = "0",
	},
	{
		.key = "ro.boot.verifiedbootstate",
		.value = "green",
	},
	{
		.key = "ro.boot.veritymode",
		.value = "enforcing",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Thu Jun 15 10:24:29 CST 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1497493469",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.build.characteristics",
		.value = "nosdcard",
	},
	{
		.key = "ro.build.date",
		.value = "Thu Jun 15 10:24:29 CST 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1497493469",
	},
	{
		.key = "ro.build.description",
		.value = "song-user 7.1.2 N2G47J V8.5.3.0.0.NCJCNED release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "N2G47J",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Xiaomi/meri/meri:7.1.2/N2G47J/V8.5.3.0.0.NCJCNED:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "song-user",
	},
	{
		.key = "ro.build.host",
		.value = "c3-miui-ota-bd09.bj",
	},
	{
		.key = "ro.build.id",
		.value = "N2G47J",
	},
	{
		.key = "ro.build.product",
		.value = "song",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "builder",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "V8.5.3.0.0.NCJCNED",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "7.1.2",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "25",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-05-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-xiaomi",
	},
	{
		.key = "ro.com.google.locationfeatures",
		.value = "1",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Alarm_Classic.ogg",
	},
	{
		.key = "ro.config.elder-ringtone",
		.value = "Angel.mp3",
	},
	{
		.key = "ro.config.max_starting_bg",
		.value = "4",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "pixiedust.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Ring_Synth_04.ogg",
	},
	{
		.key = "ro.config.sms_delivered_sound",
		.value = "MessageComplete.ogg",
	},
	{
		.key = "ro.config.sms_received_sound",
		.value = "FadeIn.ogg",
	},
	{
		.key = "ro.config.vc_call_vol_steps",
		.value = "11",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-0",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.dev.imei1",
		.value = "862391035860113",
	},
	{
		.key = "ro.dev.imei2",
		.value = "862391036060119",
	},
	{
		.key = "ro.dirac.acs.controller",
		.value = "afm",
	},
	{
		.key = "ro.dirac.acs.storeSettings",
		.value = "1",
	},
	{
		.key = "ro.dirac.afm.mode",
		.value = "global",
	},
	{
		.key = "ro.dirac.config",
		.value = "66",
	},
	{
		.key = "ro.dirac.config_path",
		.value = "/vendor/etc/audio/meri/diracmobile.config",
	},
	{
		.key = "ro.dirac.poolsize",
		.value = "2",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x69417ef0f89bc80082ed241388a04ba1581a1182376d101747b4a3bb8171d7e8",
	},
	{
		.key = "ro.hardware",
		.value = "song",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "48",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "72",
	},
	{
		.key = "ro.miui.cust_variant",
		.value = "us",
	},
	{
		.key = "ro.miui.has_cust_partition",
		.value = "true",
	},
	{
		.key = "ro.miui.has_handy_mode_sf",
		.value = "1",
	},
	{
		.key = "ro.miui.has_real_blur",
		.value = "1",
	},
	{
		.key = "ro.miui.mcc",
		.value = "9310",
	},
	{
		.key = "ro.miui.mnc",
		.value = "9999",
	},
	{
		.key = "ro.miui.region",
		.value = "US",
	},
	{
		.key = "ro.miui.ui.version.code",
		.value = "6",
	},
	{
		.key = "ro.miui.ui.version.name",
		.value = "V8",
	},
	{
		.key = "ro.miui.version.code_time",
		.value = "1492617600",
	},
	{
		.key = "ro.opengles.version",
		.value = "196610",
	},
	{
		.key = "ro.product.board",
		.value = "",
	},
	{
		.key = "ro.product.brand",
		.value = "Xiaomi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cuptsm",
		.value = "XIAOMI|ESE|02|01",
	},
	{
		.key = "ro.product.device",
		.value = "meri",
	},
	{
		.key = "ro.product.first_api_level",
		.value = "23",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "Xiaomi",
	},
	{
		.key = "ro.product.mod_device",
		.value = "meri_global",
	},
	{
		.key = "ro.product.model",
		.value = "MI 5C",
	},
	{
		.key = "ro.product.name",
		.value = "meri",
	},
	{
		.key = "ro.recovery_id",
		.value = "0x714ddbb84668b08ee0e562e36fdebf1130e9bcb3285de6abdb81aee5e7526de3",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.gprsclass",
		.value = "10",
	},
	{
		.key = "ro.ril.hsxpa",
		.value = "1",
	},
	{
		.key = "ro.ril.miui.imei0",
		.value = "862391035860113",
	},
	{
		.key = "ro.ril.miui.imei1",
		.value = "862391036060119",
	},
	{
		.key = "ro.ril.modem.pb",
		.value = "0",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "946686643615",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "1d1fb852",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.song.dual2single",
		.value = "1",
	},
	{
		.key = "ro.song.msms",
		.value = "221",
	},
	{
		.key = "ro.ss.nohidden",
		.value = "true",
	},
	{
		.key = "ro.ss.version",
		.value = "5.1.111-004",
	},
	{
		.key = "ro.sys.display.support",
		.value = "59",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "song-ipc-agent-stat",
		.value = "hs-ok",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.elog_service.flag",
		.value = "1",
	},
	{
		.key = "sys.fake_bs_flag0",
		.value = "",
	},
	{
		.key = "sys.fake_bs_flag1",
		.value = "",
	},
	{
		.key = "sys.is_keyguard_showing",
		.value = "0",
	},
	{
		.key = "sys.kernel.firstboot",
		.value = "946686643527",
	},
	{
		.key = "sys.keyguard.bleunlock",
		.value = "true",
	},
	{
		.key = "sys.keyguard.screen_off_by_lid",
		.value = "false",
	},
	{
		.key = "sys.logbootcomplete",
		.value = "1",
	},
	{
		.key = "sys.miui.user_authenticated",
		.value = "true",
	},
	{
		.key = "sys.panel.color",
		.value = "UNKNOWN",
	},
	{
		.key = "sys.pinecone.usb.state",
		.value = "1",
	},
	{
		.key = "sys.radio.config.running",
		.value = "0",
	},
	{
		.key = "sys.ril.1.cell_info",
		.value = "gsm,3,0,0,-77",
	},
	{
		.key = "sys.ril.2.cell_info",
		.value = "gsm,0,0,0,-113",
	},
	{
		.key = "sys.song.swap.nvram.standby",
		.value = "0",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.usb.config",
		.value = "adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "adb",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.has_adoptable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{NULL},
};
#endif /* __ANDROID__ */
