/*
 * Copyright (C) 2020 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2020 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-dsp-lib
 * Created on: 31 мар. 2020 г.
 *
 * lsp-dsp-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-dsp-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-dsp-lib. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef LSP_PLUG_IN_DSP_COMMON_PMATH_H_
#define LSP_PLUG_IN_DSP_COMMON_PMATH_H_

#include <lsp-plug.in/dsp/common/types.h>

#include <lsp-plug.in/dsp/common/pmath/abs_vv.h>
#include <lsp-plug.in/dsp/common/pmath/clamp.h>
#include <lsp-plug.in/dsp/common/pmath/cos.h>
#include <lsp-plug.in/dsp/common/pmath/exp.h>
#include <lsp-plug.in/dsp/common/pmath/fmop_kx.h>
#include <lsp-plug.in/dsp/common/pmath/fmop_vv.h>
#include <lsp-plug.in/dsp/common/pmath/lanczos.h>
#include <lsp-plug.in/dsp/common/pmath/log.h>
#include <lsp-plug.in/dsp/common/pmath/lramp.h>
#include <lsp-plug.in/dsp/common/pmath/minmax.h>
#include <lsp-plug.in/dsp/common/pmath/normalize.h>
#include <lsp-plug.in/dsp/common/pmath/op_kx.h>
#include <lsp-plug.in/dsp/common/pmath/op_vv.h>
#include <lsp-plug.in/dsp/common/pmath/pmix.h>
#include <lsp-plug.in/dsp/common/pmath/pow.h>
#include <lsp-plug.in/dsp/common/pmath/sin.h>
#include <lsp-plug.in/dsp/common/pmath/sqr.h>
#include <lsp-plug.in/dsp/common/pmath/sqrt.h>

#endif /* LSP_PLUG_IN_DSP_COMMON_PMATH_H_ */
