---
layout: post
title: Polyglot 1.10 - verbeteringen aan i18n_headers
lang: nl
description: Jekyll Polyglot 1.10.0 release, met verbeteringen aan SEO-generatie bij gebruik van de i18n_headers plugin
---

Jekyll-Polyglot 1.10 is nu beschikbaar. Het bevat grote verbeteringen en wijzigingen aan de `i18n_headers` liquid plugin voor SEO, en kleine aanpassingen voor idempotentie bij parallel bouwen. Communitybijdragen en Vibe Coding hebben geholpen bij een groot deel van deze releasefuncties, testen en blogpost.

## Verbeteringen aan i18n_headers

De `i18n_headers` plugin heeft nu uitgebreide mogelijkheden in deze release:

* voegt `<link rel="canonical" ...>` toe voor elke paginataal, zodat indexering uniek is op alle sites.
* voegt `<link rel="alternate" hreflang="x-default" ...>` toe om te verwijzen naar de standaardtaalversie van een site, wanneer geen overeenkomende taal door de browser wordt aangevraagd.
* definieert `<link rel="alternate" hreflang="...">` correct voor pagina's en berichten in collecties met aangepaste permalinks.
* de standaard-URL bevat nu `site.baseUrl` indien gedefinieerd.

Dit verhelpt ook een bug waarbij het relativiseren van absolute URL's deze tags onbedoeld kon wijzigen.

## Vibe-coded bijdragen

Het gebruik van bepaalde [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) tools heeft geholpen bij het vinden, meten en verifiëren van bugfixes en features voor deze release. Dit is een nieuwe aanpak voor softwareontwikkeling en maakte geavanceerde Ruby-tests mogelijk tegen Jekyll plugin-code die draait op veel gebouwde sitetalen.

De met vibe coding geschreven tests hielpen om de testdekking hoog te houden en complexe features met vertrouwen toe te voegen. Door testautomatisering konden lastige features correct worden gebouwd.

Daarnaast hielpen vibe coding tools bij het vertalen van deze blogpost naar vele talen.

## Communitybijdragen

Jekyll-Polyglot wordt ondersteund door mensen. Documentatie in menselijke taal wordt bijgedragen door mensen die deze plugin in hun moedertaal gedocumenteerd willen zien. Mensen die bugfixes en documentatie bijdragen, hebben ervoor gezorgd dat deze plugin bij elke release duizenden downloads bereikt. Door AI ondersteund programmeren, in mijn of jouw handen, zal de software die we gebruiken en de vele talen waarin we schrijven en spreken, vormgeven. 

## ruby >= 3.1 vereist

Doorlopende beveiligingsupdates voor de build-afhankelijkheden van jekyll-polyglot vereisten een grote upgrade naar ruby 3.1. Dit kan buildsystemen beïnvloeden die hun documentatie met jekyll-polyglot bouwen. Nu is een goed moment om te upgraden naar de nieuwste grote ruby-versie. Laat het weten als deze wijzigingen complicaties veroorzaken bij jekyll-builds. 